% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_to_factor.R
\name{dp_to_factor}
\alias{dp_to_factor}
\title{Recode a variable to factor using the associated categories}
\usage{
dp_to_factor(x, categorieslist = dp_categorieslist(x), warn = TRUE)
}
\arguments{
\item{x}{the variable to recode}

\item{categorieslist}{a \code{data.frame} with the categories as a
\code{data.frame}.}

\item{warn}{give a warning when there is no code list.}
}
\value{
Returns a factor vector or \code{x} when no categories could be found
(\code{categorieslist = NULL}).
}
\description{
Recode a variable to factor using the associated categories
}
\examples{
fn <- system.file("examples/iris", package = "datapackage")
dp <- open_datapackage(fn)
dta <- dp |> dp_get_data("complex", convert_categories = "no")
dp_to_factor(dta$factor1)

dp |> dp_get_data("complex", convert_categories = "to_factor")

}
\seealso{
An alternative is the \code{\link{dp_to_code}} function to convert to
'code' object from the 'codelist' package.
}
