% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_qualified_segment_missingness.R
\name{com_qualified_segment_missingness}
\alias{com_qualified_segment_missingness}
\title{Compute Indicators for Qualified Segment Missingness}
\usage{
com_qualified_segment_missingness(
  study_data,
  meta_data,
  label_col = NULL,
  meta_data_segment,
  expected_observations = c("HIERARCHY", "ALL", "SEGMENT")
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data_segment}{\link{data.frame} Segment level metadata}

\item{expected_observations}{\link{enum} HIERARCHY | ALL | SEGMENT. Report the
number of observations expected using
the old \code{PART_VAR} concept. See
\link{com_item_missingness} for an
explanation.}
}
\value{
\link{list} list with entries:
}
\description{
Compute Indicators for Qualified Segment Missingness
}
\examples{
\dontrun{
prep_load_workbook_like_file("inst/extdata/Metadata_example_v3-6.xlsx")
clean <- prep_get_data_frame("item_level")
clean <- subset(clean, `Metadata name` == "Example" &
  !dataquieR:::util_empty(VAR_NAMES))
clean$`Metadata name` <- NULL
clean <- rbind(clean, data.frame(
VAR_NAMES = "part_seg_interview",
LABEL = "PART_SEG_INTERVIEW",
VALUE_LABELS = NA_character_,
DATA_TYPE = "integer",
UNIT = NA_character_,
SCALE_LEVEL = NA_character_,
STANDARDIZED_VOCABULARY_TABLE = NA_character_,
MISSING_LIST = NA_character_,
JUMP_LIST = NA_character_,
MISSING_LIST_TABLE = "missing_matchtable1",
MISSING_CODED = NA,
HARD_LIMITS = NA_character_,
SOFT_LIMITS = NA_character_,
DETECTION_LIMITS = NA_character_,
CONTRADICTIONS = NA_character_,
DISTRIBUTION = NA_character_,
DECIMALS = NA_character_,
DATA_ENTRY_TYPE = NA_character_,
 GROUP_VAR_OBSERVER = NA_character_,
 GROUP_VAR_DEVICE = NA_character_,
 TIME_VAR = NA_character_,
 STUDY_SEGMENT = NA_character_,
 PARTICIPATION_VAR = NA_character_,
 VARIABLE_ROLE = NA_character_,
 VARIABLE_ORDER = NA_character_,
 ELEMENT_HOMOGENITY_CHECKTYPE = NA_character_,
 UNIVARIATE_OUTLIER_CHECKTYPE = NA_character_,
 LOCATION_METRIC = NA_character_,
 LOCATION_RANGE = NA_character_,
 PROPORTION_RANGE = NA_character_,
 KEY_REPEATED_MEASURES = NA_character_,
 REPEATED_MEASURES_GOLDSTANDARD = NA_character_,
 CO_VARS = NA_character_
))
prep_add_data_frames(item_level = clean)
clean <- prep_get_data_frame("segment_level")
clean <- subset(clean, `Metadata name` == "Example" &
  !dataquieR:::util_empty(STUDY_SEGMENT))
clean$`Metadata name` <- NULL
prep_add_data_frames(segment_level = clean)
clean <- prep_get_data_frame("missing_matchtable1")
clean <- clean[clean$`Metadata name` == "Example", , FALSE]
clean <- clean[suppressWarnings(as.character(as.integer(clean$CODE_VALUE)) ==
  as.character(clean$CODE_VALUE)), , FALSE]
clean$CODE_VALUE <- as.integer(clean$CODE_VALUE)
clean <- clean[!is.na(clean$`Metadata name`), , FALSE]
clean$`Metadata name` <- NULL
prep_add_data_frames(missing_matchtable1 = clean)
ship <- prep_get_data_frame("ship")
ship$part_seg_interview <-
  sample(as.numeric(prep_get_data_frame("missing_matchtable1")$CODE_VALUE),
    nrow(ship), replace = TRUE)
com_qualified_segment_missingness(ship, "item_level",
        LABEL, "segment_level")
}
}
