% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_expect_data_frame.R
\name{util_expect_data_frame}
\alias{util_expect_data_frame}
\title{Verify, that argument is a data frame}
\usage{
util_expect_data_frame(x, col_names, convert_if_possible, dont_assign)
}
\arguments{
\item{x}{an object that is verified to be a \code{data.frame}.}

\item{col_names}{column names x must contain or named list of predicates to
check the columns (e.g.,
list(AGE=is.numeric, SEX=is.character))}

\item{convert_if_possible}{if given, for each column, a lambda can be given
similar to \code{col_names} check functions. This
lambda would be used to try a conversion. If
a conversion fails (returns \code{NA}, where the
input was not `util_empty'), an error
is still thrown, the data is converted, otherwise}

\item{dont_assign}{set \code{TRUE} to keep \code{x} in the caller environment untouched}
}
\value{
\code{invisible} data frame
}
\description{
stops with an error, if not. will add the columns, and return the resulting
extended data frame, and also updating the original data frame in the
calling environment, if #' \code{x} is empty (data frames easily break to
0-columns in R, if they have not rows, e.g. using some \code{split}/\code{rbind}
pattern)
}
