% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_find_var_by_meta.R
\name{util_find_var_by_meta}
\alias{util_find_var_by_meta}
\title{Try hard, to map a variable}
\usage{
util_find_var_by_meta(
  resp_vars,
  meta_data = "item_level",
  label_col = LABEL,
  allowed_sources = c(VAR_NAMES, label_col, LABEL, LONG_LABEL),
  target = VAR_NAMES,
  ifnotfound = NA_character_
)
}
\arguments{
\item{resp_vars}{variables to map from}

\item{meta_data}{metadata}

\item{label_col}{label-col to map from, if not \code{allowed_sources} should be
entirely passed}

\item{allowed_sources}{allowed names to map from (as metadata columns)}

\item{target}{metadata attribute to map to}

\item{ifnotfound}{\link{list} A list of values to be used if the item is not
found: it will be coerced to a list if necessary.}
}
\value{
vector of mapped target names of resp_vars
}
\description{
does not warn on ambiguities nor if not found (but in the latter case,
it returns \code{ifnotfound})
}
