% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_summary.R
\name{des_summary}
\alias{des_summary}
\title{Compute Descriptive Statistics}
\usage{
des_summary(
  study_data,
  resp_vars = NULL,
  meta_data = "item_level",
  label_col = LABEL
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{resp_vars}{\link{variable} the name of the continuous measurement variable}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}
}
\value{
a list with:
\itemize{
\item SummaryTable: data frame
\item SummaryData: data frame
}
}
\description{
generates a descriptive overview on the variables ins \code{resp_vars}.

\link{Descriptor}
}
\details{
TODO
}
\examples{
\dontrun{
prep_load_workbook_like_file("meta_data_v2")
xx <- des_summary("study_data", meta_data =
                              prep_get_data_frame("item_level"))
util_html_table(xx$SummaryData)
util_html_table(des_summary(study_data = prep_get_data_frame("study_data"),
                   meta_data = prep_get_data_frame("item_level"))$SummaryData)
}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_des_impl_summary.html}{Online Documentation}
}
