% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_html_table.R
\name{util_html_table}
\alias{util_html_table}
\title{The jack of all trades device for tables}
\usage{
util_html_table(
  tb,
  filter = "top",
  columnDefs = NULL,
  autoWidth = FALSE,
  hideCols = character(0),
  rowCallback = DT::JS("function(r,d) {$(r).attr('height', '2em')}"),
  copy_row_names_to_column = !is.null(tb) && length(rownames(tb)) == nrow(tb) &&
    !is.integer(attr(tb, "row.names")) && !all(seq_len(nrow(tb)) == rownames(tb)),
  link_variables = TRUE,
  tb_rownames = FALSE,
  meta_data,
  rotate_headers = FALSE,
  fillContainer = TRUE,
  ...,
  colnames,
  descs,
  options = list(),
  is_matrix_table = FALSE,
  colnames_aliases2acronyms = is_matrix_table && !cols_are_indicatormetrics,
  cols_are_indicatormetrics = FALSE,
  label_col = LABEL,
  output_format = c("RMD", "HTML"),
  dl_fn = "*",
  rotate_for_one_row = FALSE,
  title = dl_fn,
  messageTop = NULL,
  messageBottom = NULL
)
}
\arguments{
\item{tb}{the table as \link{data.frame}}

\item{filter}{passed to \code{DT::datatable}}

\item{columnDefs}{column specifications for the \code{datatables} JavaScript
object}

\item{autoWidth}{passed to the \code{datatables} JavaScript library}

\item{hideCols}{columns to hide (by name)}

\item{rowCallback}{passed to the \code{datatables} JavaScript library
(with default)}

\item{copy_row_names_to_column}{add a column 0 with \code{rownames}}

\item{link_variables}{considering row names being variables, convert
row names to links to the variable specific reports}

\item{tb_rownames}{number of columns from the left considered as row-names}

\item{meta_data}{the data dictionary for labels and similar stuff}

\item{rotate_headers}{rotate headers by 90 degrees}

\item{fillContainer}{see \code{DT::datatable}}

\item{...}{passed to \code{DT::datatable}}

\item{colnames}{column names for the table (defaults to \code{colnames(tb)})}

\item{descs}{\link{character} descriptions of the columns for the hover-box shown
for the column names, if not missing, this overrides
the existing description stuff from known column
names. If you have an attribute "description" of the \code{tb}, then it
overwrites everything and appears as hover text}

\item{options}{individually overwrites defaults in \code{options}
passed to \code{DT::datatable}}

\item{is_matrix_table}{create a heat map like table without padding}

\item{colnames_aliases2acronyms}{abbreviate column names considering being
analysis matrix columns by their acronyms
defined in square.}

\item{cols_are_indicatormetrics}{\link{logical} cannot be \code{TRUE},
\code{colnames_aliases2acronyms} is \code{TRUE}. \code{cols_are_indicatormetrics}
controls, if the columns are really function calls or, if
\code{cols_are_indicatormetrics} has been set to \code{TRUE}, the columns are
indicator metrics.}

\item{label_col}{label col used for mapping labels in case of
\code{link_variables} is used (that argument set to \code{TRUE} and
\code{Variables} or \code{VAR_NAMES} in \code{meta_data})}

\item{output_format}{target format \code{RMD} or \code{HTML}, for \code{RMD}, markdown will
be used in the output, for \code{HTML}, only \code{HTML} code is being generated}

\item{dl_fn}{file name for downloaded table -- see
\url{https://datatables.net/reference/button/excel}}

\item{rotate_for_one_row}{\link{logical} rotate one-row-tables}

\item{title}{\link{character} title for download formats, see
\url{https://datatables.net/extensions/buttons/examples/html5/titleMessage.html}}

\item{messageTop}{\link{character} subtitle for download formats, see
\url{https://datatables.net/extensions/buttons/examples/html5/titleMessage.html}}

\item{messageBottom}{\link{character} footer for download formats, see
\url{https://datatables.net/extensions/buttons/examples/html5/titleMessage.html}}
}
\value{
the table to be added to an \code{rmd}/´\code{html} file as
\link[htmlwidgets:htmlwidgets-package]{htmlwidgets::htmlwidgets}
}
\description{
The jack of all trades device for tables
}
\seealso{
\code{\link[=util_formattable]{util_formattable()}}

Other summary_functions: 
\code{\link{prep_combine_report_summaries}()},
\code{\link{prep_extract_classes_by_functions}()},
\code{\link{prep_extract_summary}()},
\code{\link{prep_extract_summary.dataquieR_result}()},
\code{\link{prep_extract_summary.dataquieR_resultset2}()},
\code{\link{prep_render_pie_chart_from_summaryclasses_ggplot2}()},
\code{\link{prep_render_pie_chart_from_summaryclasses_plotly}()},
\code{\link{prep_summary_to_classes}()},
\code{\link{util_as_cat}()},
\code{\link{util_extract_indicator_metrics}()},
\code{\link{util_get_category_for_result}()},
\code{\link{util_get_colors}()},
\code{\link{util_get_html_cell_for_result}()},
\code{\link{util_get_labels_grading_class}()},
\code{\link{util_get_message_for_result}()},
\code{\link{util_get_rule_sets}()},
\code{\link{util_get_ruleset_formats}()},
\code{\link{util_get_thresholds}()},
\code{\link{util_melt_summary}()},
\code{\link{util_sort_by_order}()}
}
\concept{html}
\concept{summary_functions}
\keyword{internal}
