% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnomalyAssessment.R
\name{GetAnomalyAssessmentExplanations}
\alias{GetAnomalyAssessmentExplanations}
\title{Retrieve anomaly assessment explanations.}
\usage{
GetAnomalyAssessmentExplanations(
  projectId,
  recordId,
  startDate = NULL,
  endDate = NULL,
  pointsCount = NULL
)
}
\arguments{
\item{projectId}{character. The ID of the project.}

\item{recordId}{character. The ID of the anomaly assessment record.}

\item{startDate}{POSIXct. Optional. The start of the date range to get explanations in.}

\item{endDate}{POSIXct. Optional. The end of the date range to get explanations in.}

\item{pointsCount}{integer. Optional. The number of the rows to return.}
}
\value{
The anomaly assessment explanations:
\itemize{
\item recordId. character. The ID of the record.
\item projectId. character. The project ID of the record.
\item modelId. character. The model ID of the record.
\item backtest. character. The backtest of the record.
\item source. character. The source of the record.
\item seriesId. character. the series ID of the record.
\item startDate. POSIXct. First timestamp in the response. Will be NULL if there is no
data in the specified range.
\item endDate. POSIXct. Last timestamp in the response. Will be NULL if there is no
data in the specified range.
\item shapBaseValue. numeric. Shap base value.
\item count. integer.  The number of points in the \code{data}.
\item data. list. A list of DataPoint objects in the specified date range containing:
\itemize{
\item shapExplanation. NULL or an array of up to 10 ShapleyFeatureContribution objects.
Only rows with the highest anomaly scores have Shapley explanations calculated.
\item timestamp POSIXct. Timestamp for the row.
\item prediction numeric. The output of the model for this row.
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{Each ShapleyFeatureContribution contains:
}\if{html}{\out{</div>}}

\itemize{
\item featureValue. character. The feature value for this row.
First 50 characters are returned.
\item strength numeric. The shap value for this feature and row.
\item feature character. The feature name.
}

}
}
\description{
Explanations contain predictions along with shap explanations for the most anomalous records
in the specified date range/for defined number of points.
Two out of three parameters: startDate, endDate or pointsCount must be specified.
}
\examples{
\dontrun{
projectId <- "59a5af20c80891534e3c2bde"
recordId <- "59a5af20c80891534e3c2bdb"
explanations <- GetAnomalyAssessmentExplanations(projectId, recordId, pointsCount=100,
   startDate=as.Date("2021-01-01"))
}
}
\seealso{
Other Anomaly Assessment functions: 
\code{\link{DeleteAnomalyAssessmentRecord}()},
\code{\link{GetAnomalyAssessmentPredictionsPreview}()},
\code{\link{InitializeAnomalyAssessment}()},
\code{\link{ListAnomalyAssessmentRecords}()}
}
\concept{Anomaly Assessment functions}
