% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{RequestPredictionsForDataset}
\alias{RequestPredictionsForDataset}
\title{Request predictions against a previously uploaded dataset}
\usage{
RequestPredictionsForDataset(project, modelId, datasetId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{numeric. The ID of the model to use to make predictions}

\item{datasetId}{numeric. The ID of the dataset to make predictions against (as uploaded from
UploadPredictionDataset)}
}
\value{
predictJobId to be used by GetPredictions function to retrieve
the model predictions.
}
\description{
Request predictions against a previously uploaded dataset
}
\examples{
\dontrun{
  dataset <- UploadPredictionDataset(project, diamonds_small)
  model <- GetAllModels(project)[[1]]
  modelId <- model$modelId
  predictJobId <- RequestPredictionsForDataset(project, modelId, dataset$id)
  predictions <- GetPredictions(project, predictJobId)
}
}
