% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_type.R
\name{resource_type}
\alias{resource_type}
\alias{resource_type<-}
\title{Get/set the resource type of the dataset}
\usage{
resource_type(x)

resource_type(x) <- value
}
\arguments{
\item{x}{An R dataset object inherited from data.frame, tibble, or data.table.}

\item{value}{The \code{Type$resourceTypeGeneral} is set to  \code{Dataset},
while the user can set a more specific \code{Type$resourceType} value with the \code{value}
argument. To initialize a \code{Type} parameter use \code{resource_type(x) <- "Dataset"}.}
}
\value{
Returns the \code{x} object with the \code{Type} attribute as a list.
The Type$resourceTypeGeneral is set to \code{Dataset}.
}
\description{
Get/set \code{Type} property to the dataset.
}
\details{
The DataCite resourceType definition refers back to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/#https://purl.org/dc/elements/1.1/type}{dcm:type}.
The \code{Type$resourceTypeGeneral} is set to  \code{Dataset}, while the user can set a more
specific \code{Type$resourceType} value. (See examples.)
}
\examples{
x <- data.frame()
resource_type(x) <- "Dataset"
resource_type(x)

y <- data.frame()
resource_type(y) <- "Census Data"
resource_type(y)
}
