% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{as.character}
\alias{as.character}
\alias{as.character.haven_labelled_defined}
\alias{as_character}
\alias{as_character.haven_labelled_defined}
\title{Coerce to character vector}
\usage{
as.character(x, ...)

\method{as.character}{haven_labelled_defined}(x, ...)

as_character(x, ...)

\method{as_character}{haven_labelled_defined}(x, preserve_attributes = FALSE, ...)
}
\arguments{
\item{x}{A vector created with \code{\link{defined}}.}

\item{...}{Further arguments passed to internal methods (not used).}

\item{preserve_attributes}{Defaults to \code{FALSE}. If set to \code{TRUE},
in which case the \code{unit}, \code{concept} and \code{namespace}
attributes will be preserved, but the returned value will otherwise become
a base R character vector. If false, then the effect will be similar to
\code{\link{strip_defined}}.}
}
\value{
A character vector.
}
\description{
Base R's \code{as.character()} does not support custom classes like
\code{defined}. Calling \code{as.character()} on a \code{defined} vector will drop all
metadata and class information, which equals to
\code{as_character(x, preserve_attributes = FALSE)}.

\code{as_character()} is the recommended method to convert a \code{defined}
vector to character. It is metadata-aware and ensures that the underlying data
is character before coercion.
}
\details{
\code{as_character()} uses \code{preserve_attributes = TRUE}, the resulting
vector will retain relevant metadata such as the \code{unit}, \code{concept}, and
\code{namespace} attributes, but it will no longer be of class \code{defined}. If
\code{preserve_attributes = FALSE} (default), a plain character vector is
returned with all metadata and class dropped.\cr\cr For numeric-based
\code{defined} vectors, \code{as_character()} will throw an informative error to
prevent accidental coercion of non-numeric data. \cr\cr
\code{as.character()} will give a warning that \code{as_character()} is the
preferred method.
}
\examples{
as.character(defined(c("a", "b", "c"), label = "Letter code"))
as_character(defined(c("a", "b", "c"), label = "Letter code"))
fruits <- defined(c("apple", "avocado", "kiwi"), label = "Fruit", unit = "kg")
# Keep the metadata, but revert to base R character type:
as_character(fruits, preserve_attributes = TRUE)

# Revert back to base R character type, and do not keep the metadata:
as_character(fruits, preserve_attributes = FALSE)
}
\seealso{
\code{\link[=strip_defined]{strip_defined()}}
}
