% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_values.R
\name{recode_values}
\alias{recode_values}
\alias{recode_values.numeric}
\alias{recode_values.data.frame}
\alias{change_code}
\title{Recode old values of variables into new values}
\usage{
recode_values(x, ...)

\method{recode_values}{numeric}(
  x,
  recode = NULL,
  default = NULL,
  preserve_na = TRUE,
  verbose = TRUE,
  ...
)

\method{recode_values}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  recode = NULL,
  default = NULL,
  preserve_na = TRUE,
  append = FALSE,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

change_code(x, ...)
}
\arguments{
\item{x}{A data frame, numeric or character vector, or factor.}

\item{...}{not used.}

\item{recode}{A list of named vectors, which indicate the recode pairs.
The \emph{names} of the list-elements (i.e. the left-hand side) represent the
\emph{new} values, while the values of the list-elements indicate the original
(old) values that should be replaced. When recoding numeric vectors,
element names have to be surrounded in backticks. For example,
\code{recode=list(`0`=1)} would recode all \code{1} into \code{0} in a numeric
vector. See also 'Examples' and 'Details'.}

\item{default}{Defines the default value for all values that have
no match in the recode-pairs. Note that, if \code{preserve_na=FALSE}, missing
values (\code{NA}) are also captured by the \code{default} argument, and thus will
also be recoded into the specified value. See 'Examples' and 'Details'.}

\item{preserve_na}{Logical, if \code{TRUE}, \code{NA} (missing values) are preserved.
This overrides any other arguments, including \code{default}. Hence, if
\code{preserve_na=TRUE}, \code{default} will no longer convert \code{NA} into the specified
default value.}

\item{verbose}{Toggle warnings.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:} or \code{regex("")}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}.
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-Sepal.Width:Petal.Length}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{append}{Logical or string. If \code{TRUE}, recoded or converted variables
get new column names and are appended (column bind) to \code{x}, thus returning
both the original and the recoded variables. The new columns get a suffix,
based on the calling function: \code{"_r"} for recode functions, \code{"_n"} for
\code{to_numeric()}, \code{"_f"} for \code{to_factor()}, or \code{"_s"} for
\code{slide()}. If \code{append=FALSE}, original variables in \code{x} will be
overwritten by their recoded versions. If a character value, recoded
variables are appended with new column names (using the defined suffix) to
the original data frame.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}
}
\value{
\code{x}, where old values are replaced by new values.
}
\description{
This functions recodes old values into new values and can be used to to
recode numeric or character vectors, or factors.
}
\details{
This section describes the pattern of the \code{recode} arguments, which also
provides some shortcuts, in particular when recoding numeric values.
\itemize{
\item Single values

Single values either need to be wrapped in backticks (in case of numeric
values) or "as is" (for character or factor levels). Example:
\code{recode=list(`0`=1,`1`=2)} would recode 1 into 0, and 2 into 1.
For factors or character vectors, an example is:
\code{recode=list(x="a",y="b")} (recode "a" into "x" and "b" into "y").
\item Multiple values

Multiple values that should be recoded into a new value can be separated
with comma. Example: \code{recode=list(`1`=c(1,4),`2`=c(2,3))} would recode the
values 1 and 4 into 1, and 2 and 3 into 2. It is also possible to define  the
old values as a character string, like:  \code{recode=list(`1`="1,4",`2`="2,3")}
For factors or character vectors, an example is:
\code{recode=list(x=c("a","b"),y=c("c","d"))}.
\item Value range

Numeric value ranges can be defined using the \code{:}. Example:
\code{recode=list(`1`=1:3,`2`=4:6)} would recode all values from 1 to 3 into
1, and 4 to 6 into 2.
\item \code{min} and \code{max}

placeholder to use the minimum or maximum value of the
(numeric) variable. Useful, e.g., when recoding ranges of values.
Example: \code{recode=list(`1`="min:10",`2`="11:max")}.
\item \code{default} values

The \code{default} argument defines the default value for all values that have
no match in the recode-pairs. For example,
\verb{recode=list(`1`=c(1,2),`2`=c(3,4)), default=9} would
recode values 1 and 2 into 1, 3 and 4 into 2, and all other values into 9.
If \code{preserve_na} is set to \code{FALSE}, \code{NA} (missing values) will also be
recoded into the specified default value.
\item Reversing and rescaling

See \code{\link[=reverse]{reverse()}} and \code{\link[=rescale]{rescale()}}.
}
}
\note{
You can use \code{options(data_recode_pattern = "old=new")} to switch the
behaviour of the \code{recode}-argument, i.e. recode-pairs are now following the
pattern \verb{old values = new values}, e.g. if \code{getOption("data_recode_pattern")}
is set to \code{"old=new"}, then \code{recode(`1`=0)} would recode all 1 into 0.
The default for \code{recode(`1`=0)} is to recode all 0 into 1.
}
\section{Selection of variables - the \code{select} argument}{

For most functions that have a \code{select} argument (including this function),
the complete input data frame is returned, even when \code{select} only selects
a range of variables. That is, the function is only applied to those variables
that have a match in \code{select}, while all other variables remain unchanged.
In other words: for this function, \code{select} will not omit any non-included
variables, so that the returned data frame will include all variables
from the input data frame.
}

\examples{
# numeric ----------
set.seed(123)
x <- sample(c(1:4, NA), 15, TRUE)
table(x, useNA = "always")

out <- recode_values(x, list(`0` = 1, `1` = 2:3, `2` = 4))
out
table(out, useNA = "always")

# to recode NA values, set preserve_na to FALSE
out <- recode_values(
  x,
  list(`0` = 1, `1` = 2:3, `2` = 4, `9` = NA),
  preserve_na = FALSE
)
out
table(out, useNA = "always")

# preserve na ----------
out <- recode_values(x, list(`0` = 1, `1` = 2:3), default = 77)
out
table(out, useNA = "always")

# recode na into default ----------
out <- recode_values(
  x,
  list(`0` = 1, `1` = 2:3),
  default = 77,
  preserve_na = FALSE
)
out
table(out, useNA = "always")


# factors (character vectors are similar) ----------
set.seed(123)
x <- as.factor(sample(c("a", "b", "c"), 15, TRUE))
table(x)

out <- recode_values(x, list(x = "a", y = c("b", "c")))
out
table(out)

out <- recode_values(x, list(x = "a", y = "b", z = "c"))
out
table(out)

out <- recode_values(x, list(y = "b,c"), default = 77)
# same as
# recode_values(x, list(y = c("b", "c")), default = 77)
out
table(out)


# data frames ----------
set.seed(123)
d <- data.frame(
  x = sample(c(1:4, NA), 12, TRUE),
  y = as.factor(sample(c("a", "b", "c"), 12, TRUE)),
  stringsAsFactors = FALSE
)

recode_values(
  d,
  recode = list(`0` = 1, `1` = 2:3, `2` = 4, x = "a", y = c("b", "c")),
  append = TRUE
)


# switch recode pattern to "old=new" ----------
options(data_recode_pattern = "old=new")

# numeric
set.seed(123)
x <- sample(c(1:4, NA), 15, TRUE)
table(x, useNA = "always")

out <- recode_values(x, list(`1` = 0, `2:3` = 1, `4` = 2))
table(out, useNA = "always")

# factors (character vectors are similar)
set.seed(123)
x <- as.factor(sample(c("a", "b", "c"), 15, TRUE))
table(x)

out <- recode_values(x, list(a = "x", `b, c` = "y"))
table(out)

# reset options
options(data_recode_pattern = NULL)
}
\seealso{
\itemize{
\item Functions to rename stuff: \code{\link[=data_rename]{data_rename()}}, \code{\link[=data_rename_rows]{data_rename_rows()}}, \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}}, \code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate data frames: \code{\link[=data_to_long]{data_to_long()}}, \code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to recode data: \code{\link[=rescale]{rescale()}}, \code{\link[=reverse]{reverse()}}, \code{\link[=categorize]{categorize()}}, \code{\link[=recode_values]{recode_values()}}, \code{\link[=slide]{slide()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=center]{center()}}, \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split and merge data frames: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=data_select]{data_select()}}, \code{\link[=data_find]{data_find()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
