% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeg.R
\encoding{UTF-8}
\name{load_seeg}
\alias{load_seeg}
\title{Greenhouse gases emission estimates (SEEG)}
\usage{
load_seeg(dataset = "seeg", raw_data, geo_level, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("seeg").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality".}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads data of estimates of emission of greenhouse gases
}
\examples{
\dontrun{
# download state raw data
seeg <- load_seeg(dataset = 'seeg',
                  raw_data = TRUE,
                  geo_level = "state")
}
}
