% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_calibrations_pathd8.R
\name{use_calibrations_pathd8}
\alias{use_calibrations_pathd8}
\title{Date a tree with secondary calibrations using PATHd8}
\usage{
use_calibrations_pathd8(
  phy = NULL,
  calibrations = NULL,
  expand = 0.1,
  giveup = 100
)
}
\arguments{
\item{phy}{A \code{phylo} object with branch lengths.}

\item{calibrations}{A \code{data.frame} of secondary calibrations for any pair of taxon
names in \code{phy}, usually obtained with \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}

\item{expand}{How much to expand by each step to get consistent calibrations. Should be between 0 and 1.}

\item{giveup}{How many expansions to try before giving up}
}
\value{
A \code{phylo} object with branch lengths proportional to time.
}
\description{
\code{use_calibrations_pathd8} uses secondary calibrations to date a tree with initial branch lengths using PATHd8.
}
\details{
This function implements the \href{https://www2.math.su.se/PATHd8/}{PATHd8} algorithm
described in Britton et al. (2007) \doi{10.1080/10635150701613783}, with \code{\link[geiger:geiger-internal]{geiger::PATHd8.phylo()}}.
The function first attempts to use the given calibrations as fixed ages.
If that fails (often due to conflict between calibrations), it will expand the
range of the minimum age and maximum age and try again. And repeat.
If expand = 0, it uses the summarized calibrations.
In some cases, it returns edge lengths in relative time (with maximum tree depth = 1)
instead of absolute time, as given by calibrations. In this case, the function returns NA.
This is an issue from PATHd8.
}
\references{
Britton, T., Anderson, C. L., Jacquet, D., Lundqvist, S., & Bremer, K. (2007).
"Estimating divergence times in large phylogenetic trees". Systematic biology,
56(5), 741-752. \doi{10.1080/10635150701613783}.
}
