% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description_check.R
\name{description_check}
\alias{description_check}
\title{Description Check}
\usage{
description_check(DD.dict, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{verbose}{When TRUE, the function prints the Message out, as well as a list of the variables that are missing a \code{VARDESC} or have a duplicated \code{VARDESC}.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (Names of the variables with missing or duplicated descriptions).
}
\description{
This function checks that there is a unique description for every variable in the data dictionary (\code{VARDESC} column).
}
\examples{
# Example 1: Fail check 
data(ExampleG)
description_check(DD.dict.G)
print(description_check(DD.dict.G, verbose=FALSE))

# Example 2: Pass check
data(ExampleA)
description_check(DD.dict.A)
print(description_check(DD.dict.A, verbose=FALSE))
}
