% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_check.R
\name{field_check}
\alias{field_check}
\title{Field Check}
\usage{
field_check(DD.dict, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{verbose}{When TRUE, the function prints the Message out, as well as a list of the fields not found in the data dictionary.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (Named vector of TRUE/FALSE values alerting user if checks passed (TRUE) or failed (FALSE) for \code{VARNAME}, \code{VARDESC}, \code{UNITS}, and \code{VALUE}).
}
\description{
This function checks for dbGaP required fields variable name (\code{VARNAME}), variable description (\code{VARDESC}), units (\code{UNITS}), and variable value and meaning (\code{VALUES}).
}
\examples{
data(ExampleA)
field_check(DD.dict.A)
print(field_check(DD.dict.A, verbose=FALSE))
}
