% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbflob.R
\name{write_flob}
\alias{write_flob}
\title{Write flob}
\usage{
write_flob(flob, column_name, table_name, key, conn, exists = NA)
}
\arguments{
\item{flob}{A flob.}

\item{column_name}{A string of the name of the BLOB column.}

\item{table_name}{A string of the name of the existing table.}

\item{key}{A data.frame whose columns and values are used to filter the
table to a single row (this in combination with the \code{column_name}
argument are used to target a single cell within the table to modify).}

\item{conn}{A SQLite connection object.}

\item{exists}{A logical scalar specifying whether the column must (TRUE) or
mustn't (FALSE) already exist or whether it doesn't matter (NA).
IF FALSE, a new BLOB column is created.}
}
\value{
An invisible copy of flob.
}
\description{
Write a \code{\link[flobr]{flob}} to a SQLite database.
}
\examples{
flob <- flobr::flob_obj
conn <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbWriteTable(conn, "Table1", data.frame(IntColumn = c(1L, 2L)))
DBI::dbReadTable(conn, "Table1")
key <- data.frame(IntColumn = 2L)
write_flob(flob, "BlobColumn", "Table1", key, conn, exists = FALSE)
DBI::dbReadTable(conn, "Table1")
DBI::dbDisconnect(conn)
}
