% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_carrier_node_parser.R
\name{carriers_articles}
\alias{carriers_articles}
\title{Extracts the drug carriers articles element and return
 data as tibble.}
\usage{
carriers_articles(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}

\item{save_csv}{boolean, save csv version of parsed tibble if true}

\item{csv_path}{location to save csv files into it, default is current
location, save_csv must be true}

\item{override_csv}{override existing csv, if any, in case it is true in the
new parse operation}

\item{database_connection}{DBI connection object that holds a connection to
user defined database. If \code{save_table} is enabled without providing
value for this function an error will be thrown.}
}
\value{
drug carriers_articles node attributes date frame
}
\description{
\code{carriers_articles} returns tibble of
drug carriers articles elements.
}
\details{
This functions extracts the carriers articles element of drug node in
drugbank
xml database with the option to save it in a predefined database via
passed database connection. It takes two optional arguments to
save the returned tibble in the database \code{save_table} and
\code{database_connection}.
It must be called after \code{\link{read_drugbank_xml_db}} function like
any other parser function.
If \code{\link{read_drugbank_xml_db}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\dontrun{
# return only the parsed tibble
carriers_articles()

# will throw an error, as database_connection is NULL
carriers_articles(save_table = TRUE)

# save in database in SQLite in memory database and return parsed tibble
sqlite_con <- DBI::dbConnect(RSQLite::SQLite())
carriers_articles(save_table = TRUE, database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in current
# location and return parsed tibble.
# If the csv exist before read it and return its data.
carriers_articles(save_csv = TRUE)

# save in database, save parsed tibble as csv if it does not exist in
# current location and return parsed tibble.
# If the csv exist before read it and return its data.
carriers_articles(save_table = TRUE, save_csv = TRUE,
 database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in given location
# and return parsed tibble.
# If the csv exist before read it and return its data.
carriers_articles(save_csv = TRUE, csv_path = TRUE)

# save parsed tibble as csv if it does not exist in current
# location and return parsed tibble.
# If the csv exist override it and return it.
carriers_articles(
  save_csv = TRUE, csv_path = TRUE,
  override = TRUE
)
}
}
\seealso{
Other carriers: 
\code{\link{carriers_actions}()},
\code{\link{carriers_links}()},
\code{\link{carriers_polypeptide_ext_id}()},
\code{\link{carriers_polypeptides_go}()},
\code{\link{carriers_polypeptides_pfams}()},
\code{\link{carriers_polypeptides_syn}()},
\code{\link{carriers_polypeptide}()},
\code{\link{carriers_textbooks}()},
\code{\link{carriers}()}
}
\concept{carriers}
