% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sNNclust.R
\name{sNNclust}
\alias{sNNclust}
\alias{snnclust}
\title{Shared Nearest Neighbor Clustering}
\usage{
sNNclust(x, k, eps, minPts, borderPoints = TRUE, ...)
}
\arguments{
\item{x}{a data matrix/data.frame (Euclidean distance is used), a
precomputed \link{dist} object or a kNN object created with \code{\link[=kNN]{kNN()}}.}

\item{k}{Neighborhood size for nearest neighbor sparsification to create the
shared NN graph.}

\item{eps}{Two objects are only reachable from each other if they share at
least \code{eps} nearest neighbors. Note: this is different from the \code{eps} in DBSCAN!}

\item{minPts}{minimum number of points that share at least \code{eps}
nearest neighbors for a point to be considered a core points.}

\item{borderPoints}{should border points be assigned to clusters like in
\link{DBSCAN}?}

\item{...}{additional arguments are passed on to the k nearest neighbor
search algorithm. See \code{\link[=kNN]{kNN()}} for details on how to control the
search strategy.}
}
\value{
A object of class \code{general_clustering} with the following
components:
\item{cluster }{A integer vector with cluster assignments. Zero
indicates noise points.}
\item{type }{ name of used clustering algorithm.}
\item{param }{ list of used clustering parameters. }
}
\description{
Implements the shared nearest neighbor clustering algorithm by Ertoz,
Steinbach and Kumar (2003).
}
\details{
\strong{Algorithm:}
\enumerate{
\item Constructs a shared nearest neighbor graph for a given k. The edge
weights are the number of shared k nearest neighbors (in the range of
\eqn{[0, k]}).
\item Find each points SNN density, i.e., the number of points which have a
similarity of \code{eps} or greater.
\item Find the core points, i.e., all points that have an SNN density greater
than \code{MinPts}.
\item Form clusters from the core points and assign border points (i.e.,
non-core points which share at least \code{eps} neighbors with a core point).
}

Note that steps 2-4 are equivalent to the DBSCAN algorithm (see \code{\link[=dbscan]{dbscan()}})
and that \code{eps} has a different meaning than for DBSCAN. Here it is
a threshold on the number of shared neighbors (see \code{\link[=sNN]{sNN()}})
which defines a similarity.
}
\examples{
data("DS3")

# Out of k = 20 NN 7 (eps) have to be shared to create a link in the sNN graph.
# A point needs a least 16 (minPts) links in the sNN graph to be a core point.
# Noise points have cluster id 0 and are shown in black.
cl <- sNNclust(DS3, k = 20, eps = 7, minPts = 16)
plot(DS3, col = cl$cluster + 1L, cex = .5)

}
\references{
Levent Ertoz, Michael Steinbach, Vipin Kumar, Finding Clusters
of Different Sizes, Shapes, and Densities in Noisy, High Dimensional Data,
\emph{SIAM International Conference on Data Mining,} 2003, 47-59.
\doi{10.1137/1.9781611972733.5}
}
\seealso{
Other clustering functions: 
\code{\link{dbscan}()},
\code{\link{extractFOSC}()},
\code{\link{hdbscan}()},
\code{\link{jpclust}()},
\code{\link{optics}()}
}
\author{
Michael Hahsler
}
\concept{clustering functions}
\keyword{clustering}
\keyword{model}
