\name{mcmc_ddepn}
\alias{mcmc_ddepn}
\alias{runmcmc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
mcmc_ddepn - Perform MCMC sampling for DDEPN.
}
\description{
MCMC sampling for DDEPN. Takes an initial network and samples from the posterior. \code{runmcmc}
is a wrapper function for multiple calls of \code{mcmc_ddepn}, in case that multiple cores
are used for parallel MCMC runs.
}
\usage{
mcmc_ddepn(dat, phiorig=NULL, phi=NULL, stimuli=NULL,
    th=0.8, multicores=FALSE, outfile=NULL, maxiterations=10000,
    usebics=FALSE, cores=2, lambda=NULL, B=NULL,Z=NULL,
    samplelambda=TRUE, hmmiterations=30, fanin=4,
    gam=NULL, it=NULL, K=NULL, burnin=1000)
    
runmcmc(x,dat,phiorig,phi,stimuli,th,multicores,outfile,maxiterations,
		usebics,cores,lambda,B,Z,samplelambda,hmmiterations,fanin,gam,it,K,burnin)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dat}{The data matrix.}
  \item{phiorig}{The reference network to compare to. Can be NULL.}
  \item{phi}{The start network. Empty if NULL.}
  \item{stimuli}{The stimuli list.}
  \item{th}{Threshold for inclusion of an edge in the final network.}
  \item{multicores}{Use multiple cores. Not used here.}
  \item{outfile}{File to which the network should be drawn.}
  \item{maxiterations}{Integer. Maximum number of MCMC iterations.}
  \item{usebics}{Use bics for model selection.}
  \item{cores}{Not used here.}
  \item{lambda}{Strength of prior influence.}
  \item{B}{Prior information matrix.}
  \item{Z}{Normalisation factor for prior.}
  \item{hmmiterations}{Maximum iterations in the HMM.}
  \item{fanin}{Integer: maximal indegree for nodes.}
  \item{gam}{Prior influence strength in sparsity prior.}
  \item{it}{Number of iterations to generate background distribution in sparsity prior.}
  \item{K}{Proportionality factor in sparsity prior}
  \item{samplelambda}{Boolean. TRUE if laplace prior hyperparameter \code{lambda} should be sampled.
    FALSE if fixed \code{lambda} is to be used. Unused if \code{lambda} or \code{B} equal zero.}
  \item{x}{List containing two items: An adjacency matrix \code{phi} and a string \code{outfile} describing
    a path.}
  \item{burnin}{Integer. Specifies the number of iterations used as burnin phase for
   \code{\link{mcmc_ddepn}}.}
}
\details{
Usually this function is called internally by \code{\link{ddepn}}.
}
\value{
  A list of the following elements:
  \item{phi}{The inferred network.}
  \item{L}{Likelihood.}
  \item{aic}{Akaikes Information Criterion.}
  \item{bic}{Bayesian Information Criterion.}
  \item{posterior}{Posterior probability.}
  \item{dat}{The data matrix.}
  \item{theta}{The parameter matrix for the gaussians.}
  \item{gamma}{The state transition matrix.}
  \item{gammaposs}{The theoretical state transition matrix, as generated by the effect propagation.}
  \item{tps}{Vector of time points.}
  \item{stimuli}{List of stimuli.}
  \item{reps}{Number of replicates.}
  \item{hmmiterations}{Maximum number of iterations during an HMM run.}
  \item{TSA}{deprecated}
  \item{Tt}{deprecated}  
  \item{lastmove}{Type of the last change that was performed.}
  \item{coords}{Position in the network where the last change was performed.}
  \item{lambda}{Laplace prior hyperparameter.}
  \item{B}{Laplace prior matrix.}
  \item{Z}{Laplace prior normalisation factor.}
  \item{pegm}{Probability of performing the last move.}
  \item{pegmundo}{Probability of reverting the last move.}
  \item{nummoves}{Total number of possible moves in the current step.}  
  \item{fanin}{Maximal indegree for nodes.}
  \item{gam}{Sparsity prior hyperparameter.}
  \item{it}{Sparsity prior iterations.}
  \item{K}{Sparsity prior scaling factor.}
  \item{conf.act}{Matrix of beliefs that an edge is an activation. (equals \eqn{freqa/eoccur})}
  \item{conf.inh}{Matrix of beliefs that an edge is an inhibition. (equals \eqn{freqi/eoccur})}
  \item{eoccur}{Matrix of total occurrences of edges. }
  \item{phi.orig}{Adjacency of reference network, if given. }
  \item{stats}{Matrix of scores and statistics recorded during MCMC.}
  \item{freqa}{Counts how often an edge was an activation.}
  \item{freqi}{Counts how often an edge was an activation.}
}
\references{
TODO
}
\author{
Christian Bender
}
\note{
TODO
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ddepn}}
}
\examples{
\dontrun{
## load package
library(ddepn)

## sample a network
n <- 6
signet <- signalnetwork(n=n, nstim=2, cstim=0, prop.inh=0.2)
phit <- signet$phi
stimuli <- signet$stimuli

## sample data
dataset <- makedata(phit, stimuli, mu.bg=1200, sd.bg=400, mu.signal.a=2000, sd.signal.a=1000)

## uniform prior matrix
B <- matrix(0.5, nrow=n, ncol=n, dimnames=dimnames(phit))

## prior normalisation factor
lambda <- 5 
Z <- zlambda(B, lambda)

## network to start with
V <- rownames(dataset$datx)
phistart <- matrix(0, nrow=n, ncol=n, dimnames=list(V,V))

## now the sampling

ret <- mcmc_ddepn(dataset$datx, phiorig=phit, phi=phistart, stimuli=stimuli,
            th=th, multicores=FALSE, outfile=NULL, maxiterations=300,
            usebics=FALSE, cores=1, lambda=lambda, B=B, Z=Z,
            hmmiterations=100, fanin=4, burnin=100)
}

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
