% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencies.dea_fuzzy.R
\name{efficiencies.dea_fuzzy}
\alias{efficiencies.dea_fuzzy}
\title{Efficiencies}
\usage{
\method{efficiencies}{dea_fuzzy}(x, ...)
}
\arguments{
\item{x}{Object of class \code{dea_fuzzy} obtained with some of the fuzzy DEA
\code{modelfuzzy_*} functions.}

\item{...}{Other options (for compatibility).}
}
\description{
Extract the scores (optimal objective values) of the evaluated DMUs
from a fuzzy DEA solution. Note that these scores may not always be interpreted
as efficiencies.
}
\examples{
# Replication of results in Boscá, Liern, Sala and Martínez (2011, p.125)
data("Leon2003")
data_example <- make_deadata_fuzzy(datadea = Leon2003,
                                   inputs.mL = 2, 
                                   inputs.dL = 3, 
                                   outputs.mL = 4, 
                                   outputs.dL = 5)
result <- modelfuzzy_kaoliu(data_example,
                            kaoliu_modelname = "basic", 
                            alpha = seq(0, 1, by = 0.1), 
                            orientation = "io", 
                            rts = "vrs")
efficiencies(result) 
 
}
\references{
Boscá, J.E.; Liern, V.; Sala, R.; Martínez, A. (2011). "Ranking Decision Making
Units by Means of Soft Computing DEA Models". International Journal of Uncertainty,
Fuzziness and Knowledge-Based Systems, 19(1), p.115-134.
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
