% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dea.R
\name{plot.dea}
\alias{plot.dea}
\title{Plot for DEA models.}
\usage{
\method{plot}{dea}(x, tol = 1e-04, showPlots = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{dea} obtained by a DEA model function.}

\item{tol}{Numeric. Absolute tolerance for numeric comparisons. By default, it is 1e-4.}

\item{showPlots}{Logical. When TRUE (default) the plots are shown one by one. When it 
is FALSE the plots are not shown and are returned by the function (invisibly) as a list.}

\item{...}{Ignored, for compatibility issues.}
}
\value{
Depending on the model, it returns some plots.
}
\description{
Plot some attribute of a DEA model.
}
\examples{
data_example <- make_deadata(datadea = Fortune500,
                             inputs = 2:4, 
                             outputs = 5:6)
result <- model_basic(data_example)
plot(result)

}
\references{
Zhu, J. (2014). Quantitative Models for Performance Evaluation and Benchmarking.
Data Envelopment Analysis with Spreadsheets. 3rd Edition Springer, New York.
\doi{10.1007/978-3-319-06647-9}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
