%                               -*- Mode: Rd -*- 
% networkfamily.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:26 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Mar 16 13:55:56 2005
% Update Count    : 45
% Status          : Unknown, Use with caution!
% 

\name{networkfamily}
\alias{networkfamily}
\alias{print.networkfamily}
\alias{plot.networkfamily}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Generates and learns all networks for a set of variables.}

\description{Method for generating and learning all networks that are
possible for a given set of variables. These may be
  plotted or printed. Also, functions for
sorting according to the network score (see \code{\link{nwfsort}}) and for 
making a network family unique (see the \code{unique} method for
\code{networkfamily} objects) are available.  }

\usage{
networkfamily(data,nw=network(data), prior=jointprior(nw),
              trylist=vector("list",size(nw)), timetrace=TRUE) 

\method{print}{networkfamily}(x,...)
\method{plot}{networkfamily}(x,layout=,
        cexscale=5,arrowlength=0.1,sscale=7,...) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}. This should be the
  empty network for the set of variables.}
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
  \item{x}{an object of class \code{networkfamily}.}
  \item{layout}{a numeric two dimensional vector with the number of plots in the rows
    and columns of each plotting page. Default set to \code{rep(min(1+floor(sqrt(length(x))),5),2)}.}
  \item{cexscale}{a numeric. A scaling parameter to set the size of the nodes.}
  \item{arrowlength}{a numeric, which gives the length of the arrow heads.}
  \item{sscale}{a numeric. The nodes are initially placed on a circle
    with radius \code{sscale}.} 
  \item{...}{additional plot arguments passed to the plot method for network
    objects.}
}

\details{
  \code{networkfamily} generates and learns all possible networks with
  the nodes given as in the initial network \code{nw}. This is done by
  successively trying to generate the networks with all possible arrows
  to/from each node (see \code{\link{addarrows}}). If there is a ban list
  present in \code{nw} (see \code{\link{network}}), then this is
  respected, as are the restrictions described in \code{\link{insert}}.

  After generation of all possible networks, a test for cycles (see
  \code{\link{cycletest}}) is performed and only networks with directed
  acyclic graphs are returned.

}

\value{The function \code{networkfamily} returns a list with two components,
  \item{nw}{an object of class \code{networkfamily}.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\note{
  Generating all possible networks can be \emph{very} time consuming!
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.aau.dk}, \cr
  Claus Dethlefsen \email{aas.claus.dethlefsen@nja.dk}.
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.aau.dk/~dethlef/novo/deal}.
}


\seealso{\code{\link{network}},
  \code{\link{genlatex}},
  \code{\link{heuristic}},
  \code{\link{nwfsort}},
  \code{\link{unique.networkfamily}},
  \code{\link{elementin}},
  \code{\link{addarrows}},
  \code{\link{cycletest}}
}

\examples{
data(rats)
allrats <- getnetwork(networkfamily(rats))
plot(allrats)
print(allrats)
}

\keyword{iplot}
