% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtnorm90ci.R
\name{rtnorm90ci}
\alias{rtnorm90ci}
\alias{rposnorm90ci}
\alias{rtnorm_0_1_90ci}
\title{90\%-confidence interval based truncated normal random number generation.}
\usage{
rtnorm90ci(
  n,
  ci,
  median = mean(ci),
  lowerTrunc = -Inf,
  upperTrunc = Inf,
  method = "numeric",
  relativeTolerance = 0.05,
  ...
)

rposnorm90ci(
  n,
  lower,
  median = mean(c(lower, upper)),
  upper,
  method = "numeric",
  relativeTolerance = 0.05,
  ...
)

rtnorm_0_1_90ci(
  n,
  lower,
  median = mean(c(lower, upper)),
  upper,
  method = "numeric",
  relativeTolerance = 0.05,
  ...
)
}
\arguments{
\item{n}{Number of generated observations.}

\item{ci}{\code{numeric} 2-dimensional vector; lower, i.e \code{ci[[1]]}, and upper bound, i.e
\code{ci[[2]]}, of the  90\%-confidence interval.}

\item{median}{if \code{NULL}: truncated normal is fitted only to lower and upper value of the 
confidence interval; if \code{numeric}: truncated normal is fitted on the confidence interval 
and the median simultaneously. For details cf. below. This option is only relevant if 
\code{method="fit"}.}

\item{lowerTrunc}{\code{numeric}; lower truncation point of the distribution (>= \code{-Inf}).}

\item{upperTrunc}{\code{numeric}; upper truncation point of the distribution (<= \code{Inf}).}

\item{method}{method used to determine the parameters of the truncated normal; possible methods 
are \code{"numeric"} (the default) and \code{"fit"}.}

\item{relativeTolerance}{\code{numeric}; the relative tolerance level of deviation of the
generated confidence interval from the specified interval. If this deviation is greater than
\code{relativeTolerance} a warning is given.}

\item{...}{further parameters to be passed to \code{\link{paramtnormci_numeric}} or 
\code{\link{paramtnormci_fit}}, respectively.}

\item{lower}{\code{numeric}; lower bound of the 90\% confidence interval.}

\item{upper}{\code{numeric}; upper bound of the 90\% confidence interval.}
}
\description{
\code{rtnorm90ci} generates truncated normal random numbers based on the 90\% confidence interval
calculating the distribution parameter numerically from the  90\%-confidence interval or via a 
fit on the 90\%-confidence interval. The fit might include the median or not.

\code{rposnorm90ci} generates positive normal random numbers based on the 90\% confidence interval. 
It is a wrapper function for \code{rtnorm90ci}.

\code{rtnorm_0_1_90ci} generates normal random numbers truncated to \eqn{[0,1]} based on the 
90\% confidence interval. It is a wrapper function for \code{rtnorm90ci}.
}
\details{
\code{method="numeric"} is implemented by \code{\link{paramtnormci_numeric}} and 
\code{method="fit"} by \code{\link{paramtnormci_fit}}.

Positive normal random number generation: a positive normal distribution
is a truncated normal distribution with lower truncation point equal to zero and upper truncation
is infinity. \code{rposnorm90ci} implements this as a wrapper function for \ifelse{latex}{\cr}{ }
\code{rtnorm90ci(n, c(lower,upper), median, lowerTrunc=0, upperTrunc=Inf, method, relativeTolerance,...)}.

0-1-(truncated) normal random number generation: a 0-1-normal distribution
is a truncated normal distribution with lower truncation point equal to zero and upper truncation
equal to 1. \code{rtnorm_0_1_90ci} implements this as a wrapper function for \ifelse{latex}{\cr}{ }
\code{rtnorm90ci(n, c(lower,upper), median, lowerTrunc=0, upperTrunc=1, method, relativeTolerance,...)}.
}
\seealso{
For the implementation of \code{method="numeric"}: \code{\link{paramtnormci_numeric}}; 
 for the implementation of \code{method="fit"}: \code{\link{paramtnormci_fit}}.
}
