% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pls.R
\name{plot_pls}
\alias{plot_pls}
\title{Visualizing Projection to Latent Structures (PLS) regression outputs for various types of Monte Carlo simulation results}
\usage{
plot_pls(
  plsrResults,
  input_table = NULL,
  cut_off_line = 1,
  threshold = 0.8,
  x_axis_name = "Variable Importance in Projection",
  y_axis_name = NULL,
  legend_name = "Coefficient",
  legend_labels = c("Positive", "Negative"),
  pos_color = "cadetblue",
  neg_color = "firebrick",
  base_size = 11,
  ...
)
}
\arguments{
\item{plsrResults}{is an object of Projection to Latent Structures (PLS) regression outputs from the \code{\link[decisionSupport:plsr.mcSimulation]{plsr.mcSimulation}} function}

\item{input_table}{is a data frame with at least two columns named 'variable' and 'label'. The 'variable column should have one entry for the name of each variable contained in any of the plots. In preparing the figure, the function will replace the variable names with the labels. If the label is missing then the plot will show 'NA' in the place of the variable name. Default is NULL and uses the original variable names.}

\item{cut_off_line}{is the vertical line for the VIP variable selection. The default is 1 on the x-axis, which is a standard cut-off for VIP used for variable selection}

\item{threshold}{is the filter for reducing the number of variables shown in the plot. With this set to 0 all variables with a VIP > 0 will be shown (often a very long list). In the default setting the overall plot only shows those variables with a VIP > 0.8, which is a common cut-off for variable selection.}

\item{x_axis_name}{is the name (character string) for the title of the timeline of the intervention to be printed on the x axis in quotes.}

\item{y_axis_name}{is the name (character string) for the title of the units of the cashflow to be printed on the y axis.}

\item{legend_name}{is the name (character string) for the title of the legend}

\item{legend_labels}{is the name (character string) for the labels of the legend. The default is `c("Positive", "Negative")` and replacements should follow the same order}

\item{pos_color}{is the color to be used for positive coefficient values, default is "cadetblue"}

\item{neg_color}{is the color to be used for negative coefficient values, default is "firebrick"}

\item{base_size}{is the base text size to be used for the plot. The default is 11, this is the \code{\link[ggplot2:ggtheme]{ggplot2::ggtheme}} default}

\item{...}{accepts arguments to be passed to \code{\link[ggplot2:ggtheme]{ggplot2::ggtheme}}}
}
\value{
This function returns a plot of classes \code{'gg'}, 
and \code{'ggplot'}. This allows the user to
continue editing some features of the plots through the syntax 
\code{'+'}.
}
\description{
Plotting the Variable Importance in the Projection (VIP) statistic and coefficients of a PLS model of Monte Carlo outputs
}
\examples{
# Create the estimate object:

variable = c("labor_cost", "investment_cost", "yield", "market_price")
distribution = c("posnorm", "posnorm", "posnorm", "posnorm")
lower = c(200, 20000, 5000, 10)
upper = c(10000, 100000, 20000, 200)

costBenefitEstimate <- as.estimate(variable, distribution, lower, upper)

# Define the model function without name for the return value:

profit1 <- function(x) {
  income <- x$yield * x$market_price
  costs <- x$labor_cost + x$investment_cost
  profit <- income - costs
  return(list(Revenues = profit))
}

# Perform the Monte Carlo simulation:

predictionProfit1 <- mcSimulation(estimate = costBenefitEstimate,
                                  model_function = profit1,
                                  numberOfModelRuns = 10000,
                                  functionSyntax = "data.frameNames")


# Run the PLS analysis

pls <- plsr.mcSimulation(object = predictionProfit1,
resultName = names(predictionProfit1$y))
 
 # Plot PLS results 
 
 plot_pls(pls)

}
\references{
Do, Hoa, Eike Luedeling, and Cory Whitney. “Decision Analysis of Agroforestry Options Reveals Adoption Risks for Resource-Poor Farmers.” Agronomy for Sustainable Development 40, no. 3 (June 2020): 20. \doi{10.1007/s13593-020-00624-5}.
Lanzanova, Denis, Cory Whitney, Keith Shepherd, and Eike Luedeling. “Improving Development Efficiency through Decision Analysis: Reservoir Protection in Burkina Faso.” Environmental Modelling & Software 115 (May 1, 2019): 164–75. \doi{10.1016/j.envsoft.2019.01.016}.
Luedeling, Eike, and Keith Shepherd. “Decision-Focused Agricultural Research.” Solutions 7, no. 5 (2016): 46–54. \url{https://thesolutionsjournal.com/2016/09/17/decision-focused-agricultural-research/}.
}
\author{
Eduardo Fernandez (\email{efernand@uni-bonn.de})

Cory Whitney (\email{cory.whitney@uni-bonn.de})
}
\keyword{Monte-Carlo}
\keyword{NPV}
\keyword{decision-analysis}
\keyword{decisionSupport}
\keyword{net-present-value}
\keyword{risk}
\keyword{uncertainty}
