% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict_effector}
\alias{predict_effector}
\alias{predict_effector.character}
\alias{predict_effector.data.frame}
\alias{predict_effector.AAStringSet}
\alias{predict_effector.AAString}
\alias{predict_effector.default}
\title{Predict effector}
\usage{
predict_effector(input, taxon)

\method{predict_effector}{character}(input, taxon)

\method{predict_effector}{data.frame}(input, taxon)

\method{predict_effector}{AAStringSet}(input, taxon)

\method{predict_effector}{AAString}(input, taxon)

\method{predict_effector}{default}(input, taxon)
}
\arguments{
\item{input}{Input data that contains amino acid sequence(s). It can be in fasta format, strings, AAString, AAStringset, and dataframe.}

\item{taxon}{Taxon group of input data. Available taxons are bacteria, fungi, and oomycete.}
}
\value{
\code{predict_effector} returns an object of class "tbl_deepredeff" or for multiple responses of class c("tbl_deepredeff", "data.frame").

An object of class "tbl_deepredeff" is a data frame containing at least the following components:

\item{\code{sequence}}{the sequence(s) from the input data.}
\item{\code{s_score}}{score obtained from sigmoid function showing how likely the sequences to be an effector.}
\item{\code{prediction}}{class prediction for each sequence, obtained from s_score. If the value of \code{s_score} >= 0.5, it will be classified as an effector. Otherwise, it will be classified as a non-effector.}
}
\description{
\code{predict_effector} is used to predict effector protein given amino acid protein sequences.
}
\examples{
\donttest{
# FASTA input
input_fasta <- system.file("extdata/example/fungi_sample.fasta", package = "deepredeff")

pred_result <- deepredeff::predict_effector(
  input = input_fasta,
  taxon = "fungi"
)
}

}
