% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisquare_basis.R
\name{bisquares1D}
\alias{bisquares1D}
\title{Bisquare functions on a 1D domain}
\usage{
bisquares1D(r = 30, lims = c(-0.5, 0.5), dtype = "float32")
}
\arguments{
\item{r}{30}

\item{lims}{the limits of one side of the square bounded 2D domain on which to set up the bisquare functions}

\item{dtype}{data type}
}
\value{
\code{bisquares1D} returns a list containing a list with the following components:
\describe{
 \item{"f"}{An encapsulated function that takes an input and evaluates the sigmoids over the \code{dim}-th dimension using \code{TensorFlow}}
 \item{"r"}{The number of sigmoid basis functions}
 \item{"knots_tf"}{The centroids of the basis functions as a TensorFlow object}
}
}
\description{
Sets up a top-layer set of bisquare basis functions on a bounded 1D domain of
length 1 for modelling the process \eqn{Y}. It returns a list of length 1 containing the basis functions and encapsulated
functions that evaluate the bisquare functions over inputs of different types. See Value for more details.
}
