% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_defm}
\alias{sim_defm}
\title{Simulate data using a DEFM}
\usage{
sim_defm(m, par, fill_t0 = TRUE)
}
\arguments{
\item{m}{An object of class \link{DEFM}. The baseline model.}

\item{par}{Numeric vector of model parameters.}

\item{fill_t0}{Logical scalar. When \code{TRUE} (default) will fill-in the baseline
value of each observation (i.e., the starting condition) (see details.)}
}
\value{
An integer vector of size \verb{nrows_defm(m) x ncol_defm_y(m)}.
}
\description{
Simulate data using a DEFM
}
\details{
Each observation in the simulation must have initial condition. In practice,
this means we start the markov process with a matrix of size
\verb{morder_defm(m) x ncol_defm_y(m)}, i.e., order of the Markov process times
the number of output variables. when \code{fill_t0 = TRUE}, the function return
the rows corresponding to baseline states with the original value, otherwise
it replaces them with -1. This option is mostly for testing purposes.
}
