% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deisotoper.R
\name{findNN}
\alias{findNN}
\title{find index of nearest neighbor.}
\usage{
findNN(q, vec)
}
\arguments{
\item{q}{a double vector which can be considered as query objects.}

\item{vec}{a sorted double vector which can be considered as a data base.}
}
\value{
an integer vector
}
\description{
Given a vector of sorted double values \code{vec} of size
\code{n} and a vector of \code{m} query objects \code{q}.

\code{findNN} determines for each element \code{q[i]} in \code{q}
the nearest neighbor index \code{o} so that the following remains true:
 
 there is no element \code{k} with \code{1} \eqn{\le} \code{k}
\eqn{\le} \code{n} and \code{k} is not \code{o} so that

\code{abs(vec[k] - q[i])} < \code{abs(vec[o] - q[i])}.

 The internal algorithm of \code{findNN} is implemented as binary search.
\code{findNN} has \eqn{O(m * log(n))} time complexity.
}
\examples{
(NNidx <- findNN(q<-c(1, 1.0001, 1.24, 1.26), DB<-seq(1,5,by=0.25)))
(NNidx == c(1,1,2,2))

# should be 0
unique(DB[findNN(DB,DB)] - DB)
}
\seealso{
\code{protViz::findNN}'s cpluplus implementation.
}
\author{
Lucas Schmidt, Christian Panse
}
