% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/attr_access.R
\name{get_leaves_nodePar}
\alias{get_leaves_nodePar}
\title{Get nodePar of dendrogram's leaves}
\usage{
get_leaves_nodePar(dend, simplify = FALSE, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{simplify}{logical (default is FALSE). If TRUE, then the return vector is
after using \code{unlist} on it.}

\item{...}{not used}
}
\value{
A list (or a vector) with the dendrogram's leaves nodePar attribute
}
\description{
Get nodePar of dendrogram's leaves
}
\examples{
# define dendrogram object to play with:
hc <- hclust(dist(USArrests[1:3,]), "ave")
dend <- as.dendrogram(hc)

# get_leaves_attr(dend) # error :)
get_leaves_nodePar(dend)
labels_colors(dend) <- 1:3
get_leaves_nodePar(dend)

dend <- assign_values_to_leaves_nodePar(dend, 2, "lab.cex")
get_leaves_nodePar(dend)

plot(dend)
}
\seealso{
\link{get_nodes_attr}, \link{assign_values_to_leaves_nodePar}, \link{labels_colors}
\link{get_leaves_edgePar}
}

