% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popping.r
\name{popping}
\alias{popping}
\alias{pop}
\alias{pop.deque}
\alias{pop.queue}
\alias{pop.stack}
\alias{popback}
\alias{popback.deque}
\title{pop/popback}
\usage{
pop(x)

\method{pop}{deque}(x)

\method{pop}{queue}(x)

\method{pop}{stack}(x)

popback(x)

\method{popback}{deque}(x)
}
\arguments{
\item{x}{A queue, stack, or deque.}
}
\value{
Returns \code{NULL}; deletion operates via side-effects.
}
\description{
Remove items from the front of a stack, queue, or deque for \code{pop()}; or, 
remove items from the back of a deque for \code{popback()}.
}
\details{
Operates via side-effects; see examples for clarification on usage.
}
\examples{
\dontrun{
library(dequer)

### A simple queue example
q <- queue()
for (i in 1:3) pushback(q, i)

pop(q)
str(q)

### A simple stack example
s <- stack()
for (i in 1:3) push(s, i)
pop(s)
str(s)
}

}
