% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pushing.r
\name{pushing}
\alias{pushing}
\alias{push}
\alias{push.deque}
\alias{push.stack}
\alias{pushback}
\alias{pushback.deque}
\alias{pushback.queue}
\title{push/pushback}
\usage{
push(x, data)

\method{push}{deque}(x, data)

\method{push}{stack}(x, data)

pushback(x, data)

\method{pushback}{deque}(x, data)

\method{pushback}{queue}(x, data)
}
\arguments{
\item{x}{A queue, stack, or deque.}

\item{data}{R object to insert at the front of the deque/stack.}
}
\value{
Returns \code{NULL}; insertion operates via side-effects.
}
\description{
Add items to the front of a stack or deque via \code{pop()}.  
Add items to the back of a queue or deque via \code{popback()}.
}
\details{
Operates via side-effects; see examples for clarification on usage.
}
\examples{
\dontrun{
library(dequer)

### A simple queue example
q <- queue()
for (i in 1:3) pushback(q, i)

str(q)

### A simple stack example
s <- stack()
for (i in 1:3) push(s, i)

str(s)
}

}
