% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{detrended_img}
\alias{detrended_img}
\title{Detrended image class.}
\usage{
detrended_img(img, method, parameter, auto)
}
\arguments{
\item{img}{The detrended image series. A 3-dimensional array of non-negative
integers.}

\item{method}{The method used. One of \code{"boxcar"}, \code{"exponential"} or
\code{"polynomial"}.}

\item{parameter}{A number. The detrend parameter used.}

\item{auto}{Logical. Was automatic detrending used? This is \code{NA} if the
detrending parameter is \code{NA}.}
}
\value{
An object of class \code{detrended_img}.
}
\description{
A \link{detrended_img} is a 3-dimensional array of integers which is the result of
a detrending routine. It has 3 attributes: \describe{\item{\code{method}}{The
detrending method used. This must be one of \code{"boxcar"}, \code{"exponential"} or
\code{"polynomial"}. } \item{\code{parameter}}{The value of the parameter used. This
will be the \code{l}, \code{tau} or \code{degree} parameter for the respective methods.}
\item{\code{auto}}{A boolean that is \code{TRUE} if the parameter was found
automatically or \code{FALSE} if it was manually selected. }}
}
