% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_swaps.R
\name{best_swaps}
\alias{best_swaps}
\title{Find the best \code{swaps} parameter for \emph{Robin Hood} detrending.}
\usage{
best_swaps(img)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}
}
\value{
A natural number. The ideal \code{swaps} parameter for boxcar detrending.
If there are multiple channels, the function returns a vector, one \code{swaps}
parameter for each channel.
}
\description{
Use Nolan's algorithm to find the ideal \code{swaps} parameter for \emph{Robin Hood}
detrending.
}
\examples{
\dontrun{
## These examples are not run on CRAN because they take too long.
## You can still try them for yourself.
img <- ijtiff::read_tif(system.file('extdata', 'bleached.tif',
                                    package = 'detrendr'))
best_swaps(img)}

}
