#' Decay constant of 176Lu.
#'
#' @references Soderlund, U., Jonathan Patchett, P., Vervoort, J.D. and Isachsen
#' C.E. 2004. The 176Lu decay constant determined by Lu^Hf and U^Pb isotope
#' systematics of Precambrian mafic intrusions. Earth and Planetary Science
#' Letters 219, 311-324.

lambda_lu <- 1.867*10^-11

#' 176Lu/177Hf value of CHUR.
#'
#' @references Bouvier, A., Vervoort, J.D. and Jonathan Patchett P. 2008. The
#' Lu-Hf and Sm-Nd isotopic composition of CHUR: Constraints from unequilibrated
#' chondrites and implications for the bulk composition of terrestrial planets.
#' Earth and Planetary Science Letters 273, 48-57.

luhf_chur <- 0.0336

#' 176Hf/177Hf value of CHUR.
#'
#' @references Bouvier, A., Vervoort, J.D. and Jonathan Patchett P. 2008. The
#' Lu-Hf and Sm-Nd isotopic composition of CHUR: Constraints from unequilibrated
#' chondrites and implications for the bulk composition of terrestrial planets.
#' Earth and Planetary Science Letters 273, 48-57.

hfhf_chur <- 0.282785

#' 176Lu/177Hf value of DM.
#'
#' 176Lu/177Hf value of DM (Griffin et al., 2000) recalculated to the decay
#' constant of Soderlund et al. (2004) and the CHUR values of Bouvier et al.
#' (2008).
#'
#' @references Griffin, W., Pearson, N., Belousova, E., Jackson, S., van
#' Achterbergh, E., O'Reilly, S. and Shee, S. 2000. The Hf isotope composition
#' of cratonic mantle:
#' LAM-MC-ICPMS analysis of zircon megacrysts in kimberlites.
#' Geochimica et Cosmochimica Acta 64(1), 133-147.

luhf_dm <- 0.0388

#' 176Lu/177Hf value of DM.
#'
#' @references Griffin, W., Pearson, N., Belousova, E., Jackson, S., van
#' Achterbergh, E., O'Reilly, S. and Shee, S. 2000. The Hf isotope composition
#' of cratonic mantle:
#' LAM-MC-ICPMS analysis of zircon megacrysts in kimberlites.
#' Geochimica et Cosmochimica Acta 64(1), 133-147.

hfhf_dm <- 0.28325

#' 176Lu/177Hf value of average continental crust.
#'
#' @references Griffin, W., Belousova, E., Shee, S., Pearson, N. and O'Reilly,
#' S. 2004. Archean crustal evolution in the northern Yilgam Craton:
#' U-Pb and Hf-isotope evidence from detrital zircons. Precambrian Research,
#' 231-282.

luhf_zrc <- 0.015

#' Decay constants of 235U.
#'
#' @references Steiger, R. & Jager, E. 1977. SUBCOMMISSION ON GEOCHRONOLOGY -
#' CONVENTION ON USE OF DECAY CONSTANTS IN GEOCHRONOLOGY AND COSMOCHRONOLOGY.
#' Earth And Planetary Science Letters 36(3), 359-362.

lambda_u235 <- 9.8485 * (10^-10)

#' Decay constants of 238U.
#'
#' @references Steiger, R. & Jager, E. 1977. SUBCOMMISSION ON GEOCHRONOLOGY -
#' CONVENTION ON USE OF DECAY CONSTANTS IN GEOCHRONOLOGY AND COSMOCHRONOLOGY.
#' Earth And Planetary Science Letters 36(3), 359-362.

lambda_u238 <- 1.55125 * (10^-10)

#' Atomic ratio of 238U and 235U.
#'
#' @references Steiger, R. & Jager, E. 1977. SUBCOMMISSION ON GEOCHRONOLOGY -
#' CONVENTION ON USE OF DECAY CONSTANTS IN GEOCHRONOLOGY AND COSMOCHRONOLOGY.
#' Earth And Planetary Science Letters 36(3), 359-362.

u238_u235_ratio <- 137.88
