% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw}
\alias{draw}
\alias{draw.gp}
\alias{draw.dgp}
\alias{draw.bundle}
\title{Validation plots of a sequential design}
\usage{
draw(object, ...)

\method{draw}{gp}(object, type = "rmse", log = FALSE, ...)

\method{draw}{dgp}(object, type = "rmse", log = FALSE, ...)

\method{draw}{bundle}(object, emulator = 1, type = "rmse", log = FALSE, ...)
}
\arguments{
\item{object}{can be one of the following emulator classes:
\itemize{
\item the S3 class \code{gp}.
\item the S3 class \code{dgp}.
\item the S3 class \code{bundle}.
}}

\item{...}{N/A.}

\item{type}{either \code{"rmse"}, for the trace plot of RMSEs or customized evaluating metrics of emulators constructed during the sequential designs,
or \code{"design"}, for visualizations of input designs created by the sequential design procedure. Defaults to \code{"rmse"}.}

\item{log}{a bool that indicates whether to plot RMSEs or customized evaluating metrics in log-scale if \code{type = "rmse"}. Defaults to \code{FALSE}.}

\item{emulator}{the index of the emulator packed in \code{object} if \code{object} is an instance of the \code{bundle} class.}
}
\value{
A \code{patchwork} object.
}
\description{
This function draws validation plots of the sequential design of a (D)GP emulator or a bundle of (D)GP emulators.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
If a customized evaluating function is provided to \code{\link[=design]{design()}} and the function returns a single evaluating metric value when \code{object} is
an instance of the \code{bundle} class, the value of \code{emulator} has no effects on the plot when \code{type = "rmse"}.
}
\examples{
\dontrun{

# See design() for an example.
}
}
