% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{Dhis2r}
\alias{Dhis2r}
\title{Connect and pull/get data from a DHIS2 instance}
\format{
An R6 class called Dhis2r.
}
\description{
To create a DHIS2 connection, you need a DHIS2 base URL, username, password, and an API version
The R6 Class called `Dhis2r` representing a DHIS2 instance connection
}
\details{
You can use a DHIS2 instance connection to get data several times without needing to manually supply your user credentials on each API call.
}
\examples{
# Load dhis2r
library(dhis2r)
# connect to the DHIS2 instance
dhis2_play_connection <- Dhis2r$new(base_url = "https://play.im.dhis2.org/stable-2-40-5",
username = "admin",
password = "district")

# get all the available resources
dhis2_play_connection$get_metadata()

# get organisation Units with the default fields i.e c("name","id")

dhis2_play_connection$get_metadata(endpoint = "organisationUnits")

# get a vector of all possible fields of a organisation unit resource
dhis2_play_connection$get_metadata_fields(endpoint = "organisationUnits")

# get organisation Units with additional fields i.e c("name","id", "level")

dhis2_play_connection$get_metadata(endpoint = "organisationUnits",
fields =  c("name","id", "level"))

dhis2_play_connection$get_analytics(analytic = c("Uvn6LCg7dVU"),
org_unit =   c("O6uvpzGd5pu", "fdc6uOvgoji"),
period = "LAST_12_MONTHS",
 output_scheme = "NAME")


}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request_sent}}{The request used to perform an API call}

\item{\code{name}}{Name of the user}

\item{\code{access_rights}}{The access rights the user has on the DHIS2 instance}

\item{\code{account_info}}{Information of the logged account credentials}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Dhis2r-new}{\code{Dhis2r$new()}}
\item \href{#method-Dhis2r-get_user_info}{\code{Dhis2r$get_user_info()}}
\item \href{#method-Dhis2r-get_metadata}{\code{Dhis2r$get_metadata()}}
\item \href{#method-Dhis2r-get_metadata_fields}{\code{Dhis2r$get_metadata_fields()}}
\item \href{#method-Dhis2r-get_analytics}{\code{Dhis2r$get_analytics()}}
\item \href{#method-Dhis2r-get_any_analytic}{\code{Dhis2r$get_any_analytic()}}
\item \href{#method-Dhis2r-clone}{\code{Dhis2r$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-new"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-new}{}}}
\subsection{Method \code{new()}}{
Create a connection to a DHIS2 instance using basic authentication
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$new(
  base_url,
  username = NULL,
  password = NULL,
  api_token = NULL,
  api_version = NULL,
  api_version_position = c("after", "before")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_url}}{Base url e.g https://play.dhis2.org/}

\item{\code{username}}{Registered username e.g "admin"}

\item{\code{password}}{Registered password e.g "district"}

\item{\code{api_token}}{Personal Access Token (PAT) to use instead of username and password}

\item{\code{api_version}}{The api version e.g "33"}

\item{\code{api_version_position}}{position where the api_version is after or before in web API url i.e /api/}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Dhis2r` object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-get_user_info"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-get_user_info}{}}}
\subsection{Method \code{get_user_info()}}{
Get information of the logged in user
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$get_user_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get metadata about any available resource from a DHIS2 instance e.g "dataElements",
"organisationUnits", "indicators", "periodTypes"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$get_metadata(endpoint = NULL, fields = c("name", "id"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint}}{a resource, get the available resources using `get_metadata()` without any arguments}

\item{\code{fields}}{The specific columns to be return in the dataframe e.g c("name","id")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-get_metadata_fields"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-get_metadata_fields}{}}}
\subsection{Method \code{get_metadata_fields()}}{
Get all possible fields for a specific metadata resource from a DHIS2 instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$get_metadata_fields(endpoint)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint}}{a resource, get the available resources using `get_metadata()` without any arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of all possible fields for a specific metadata
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-get_analytics"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-get_analytics}{}}}
\subsection{Method \code{get_analytics()}}{
Get all possible analytics resources from a DHIS2 instance i.e
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$get_analytics(
  analytic,
  org_unit,
  period,
  output_scheme = c("UID", "NAME")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{analytic}}{vector of ID of specific analytic(s) from a DHIS2 instance}

\item{\code{org_unit}}{vector of ID of specific organisation unit(s) from a DHIS2 instance}

\item{\code{period}}{vector of relative or fixed periods from a DHIS2 instance}

\item{\code{output_scheme}}{Output type ID or Names of fields}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of the analytics resource
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-get_any_analytic"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-get_any_analytic}{}}}
\subsection{Method \code{get_any_analytic()}}{
Get all any analytics resource from a DHIS2 instance to cater for long DHIS2 favorites
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$get_any_analytic(endpoint_url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint_url}}{string part of Analytic(s) from a DHIS2 instance api endpoint starting from 'analytics.json?dimension='}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of the analytics resource
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dhis2r-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Dhis2r-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dhis2r$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
