% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_cubist.R
\name{extrapolation}
\alias{extrapolation}
\alias{unbiased_rules}
\alias{max_rules}
\title{Parameters for possible engine parameters for Cubist}
\usage{
extrapolation(range = c(1, 110), trans = NULL)

unbiased_rules(values = c(TRUE, FALSE))

max_rules(range = c(1L, 100L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{For \code{unbiased_rules()},  either \code{TRUE} or \code{FALSE}.}
}
\description{
These parameters are auxiliary to models that use the "Cubist"
engine. They correspond to tuning parameters that would be specified using
\code{set_engine("Cubist0", ...)}.
}
\details{
To use these, check \code{?Cubist::cubistControl} to see how they are used.
}
\examples{
extrapolation()
unbiased_rules()
max_rules()
}
