% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare data for consensus clustering}
\usage{
prepare_data(data, scale = TRUE, type = c("conventional", "robust"),
  min.var = 1)
}
\arguments{
\item{data}{data matrix with rows as samples and columns as variables}

\item{scale}{logical; should the data be centered and scaled?}

\item{type}{if we use "conventional" measures (default), then the mean and
standard deviation are used for centering and scaling, respectively. If
"robust" measures are specified, the median and median absolute deviation
(MAD) are used.}

\item{min.var}{minimum variability measure threshold used to filter the
feature space for only highly variable features. Only features with a
minimum variability measure across all samples greater than \code{min.var}
will be used. If \code{type = "conventional"}, the standard deviation is
the measure used, and if \code{type = "robust"}, the MAD is the measure
used.}
}
\value{
dataset prepared for usage in \code{consensus_cluster}
}
\description{
Remove variables with low signal and (optionally) scale before consensus
clustering.
}
\examples{
set.seed(2)
x <- replicate(10, rnorm(100))
x.prep <- prepare_data(x)
dim(x)
dim(x.prep)
}
\author{
Derek Chiu
}
