% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLR.R
\name{MLR}
\alias{MLR}
\title{DDF likelihood ratio statistics based on multinomial log-linear
regression model.}
\usage{
MLR(Data, group, key, type = "both", match = "zscore", anchor = 1:ncol(Data),
    p.adjust.method = "none", alpha = 0.05, parametrization)
}
\arguments{
\item{Data}{data.frame or matrix: dataset which rows represent
unscored examinee answers (nominal) and columns correspond to the
items.}

\item{group}{numeric: binary vector of group membership. \code{"0"}
for reference group, \code{"1"} for focal group.}

\item{key}{character: the answer key. Each element corresponds to
the correct answer of one item.}

\item{type}{character: type of DDF to be tested. Either
\code{"both"} for uniform and non-uniform DDF (i.e., difference
in parameters \code{"a"} and \code{"b"}) (default), or
\code{"udif"} for uniform DDF only (i.e., difference in
difficulty parameter \code{"b"}), or \code{"nudif"} for
non-uniform DDF only (i.e., difference in discrimination
parameter \code{"a"}). Can be specified as a single value (for
all items) or as an item-specific vector.}

\item{match}{numeric or character: matching criterion to be used as
an estimate of trait. Can be either \code{"zscore"} (default,
standardized total score), \code{"score"} (total test score), or
vector of the same length as number of observations in
\code{Data}.}

\item{anchor}{character or numeric: specification of DIF free
items. A vector of item identifiers (integers specifying the
column  number) specifying which items are currently considered
as anchor (DIF free) items. Argument is ignored if \code{match}
is not \code{"zscore"} or \code{"score"}.}

\item{p.adjust.method}{character: method for multiple comparison
correction. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"},
\code{"fdr"}, and \code{"none"} (default). For more details see
\code{\link[stats]{p.adjust}}.}

\item{alpha}{numeric: significance level (default is 0.05).}

\item{parametrization}{deprecated. Use
\code{\link[difNLR]{coef.ddfMLR}} for different
parameterizations.}
}
\value{
A list with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{par.m0}}{the estimates of null model.}
  \item{\code{par.m1}}{the estimates of alternative model.}
  \item{\code{se.m0}}{standard errors of parameters in null model.}
  \item{\code{se.m1}}{standard errors of parameters in alternative model.}
  \item{\code{cov.m0}}{list of covariance matrices of item parameters for null model.}
  \item{\code{cov.m1}}{list of covariance matrices of item parameters for alternative model.}
  \item{\code{ll.m0}}{log-likelihood of m0 model.}
  \item{\code{ll.m1}}{log-likelihood of m1 model.}
  \item{\code{AIC.m0}}{AIC of m0 model.}
  \item{\code{AIC.m1}}{AIC of m1 model.}
  \item{\code{BIC.m0}}{BIC of m0 model.}
  \item{\code{BIC.m1}}{BIC of m1 model.}
  }
}
\description{
Calculates DDF likelihood ratio statistics for nominal
  data based on multinomial log-linear model.
}
\details{
\deqn{P(y = k) = exp(b_0k + b_1k * x + b_2k * g + b_3k * x * g) / (1 + \sum exp(b_0l + b_1l * x + b_2l * g + b_3l * x * g)), }
where \eqn{x} is by default standardized total score (also called
Z-score) and \eqn{g} is a group membership. Probability of correct
answer (specified in argument \code{key}) is
\deqn{P(y = k) = 1/(1 + \sum exp(b_0l + b_1l * x + b_2l * g + b_3l * x * g)). }
Parameters are estimated via neural networks. For more details see
\code{\link[nnet]{multinom}}.
}
\examples{
\dontrun{
# loading data
data(GMATtest, GMATkey)
Data <- GMATtest[, 1:20] # items
group <- GMATtest[, "group"] # group membership variable
key <- GMATkey # correct answers

# testing both DDF effects
MLR(Data, group, key, type = "both")

# testing uniform DDF effects
MLR(Data, group, key, type = "udif")

# testing non-uniform DDF effects
MLR(Data, group, key, type = "nudif")
}

}
\references{
Agresti, A. (2010). Analysis of ordinal categorical data. Second edition. John Wiley & Sons.

Hladka, A. (2021). Statistical models for detection of differential item functioning. Dissertation thesis.
Faculty of Mathematics and Physics, Charles University.

Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression models for DIF and DDF detection.
The R Journal, 12(1), 300--323, \doi{10.32614/RJ-2020-014}.
}
\seealso{
\code{\link[stats]{p.adjust}} \code{\link[nnet]{multinom}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{DDF}
