% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliding_DI.R
\name{sliding_DI}
\alias{sliding_DI}
\title{Computes the diurnality index, using different start and end definitions for
each day and night, based on an activity dataframe}
\usage{
sliding_DI(data, activity, timedata, save = NULL)
}
\arguments{
\item{data}{a digiRhythm-friendly dataset}

\item{activity}{The number of non-useful lines to skip (lines to header)}

\item{timedata}{a dataset, including 4 columns of POSIXct format, including
date and time "day_start", "day_end", "night_start", "night_end"}

\item{save}{if NULL, the image is not saved. Otherwise, this parameter will
be the name of the saved image. it should contain the path and name without
the extension.}
}
\value{
A ggplot2 object that contains the Sliding diurnality plot in
addition to a dataframe with 2 col: date and sliding diurnality index
}
\description{
Computes the diurnality index, using different start and end definitions for
each day and night, based on an activity dataframe
}
\examples{
data("df516b_2", package = "digiRhythm")
data <- df516b_2
data <- remove_activity_outliers(data)
activity <- names(data)[2]
data("timedata", package = "digiRhythm")
timedata <- timedata
d_index <- sliding_DI(data, activity, timedata)

}
