% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.R
\docType{methods}
\name{quality,dimRedResult-method}
\alias{dimRedQualityList}
\alias{quality}
\alias{quality,dimRedResult-method}
\alias{quality.dimRedResult}
\title{Quality Criteria for dimensionality reduction.}
\usage{
\S4method{quality}{dimRedResult}(.data, .method = dimRedQualityList(),
  .mute = character(0), ...)

dimRedQualityList()
}
\arguments{
\item{.data}{object of class \code{dimRedResult}}

\item{.method}{character vector naming one of the methods}

\item{.mute}{what output from the embedding method should be muted.}

\item{...}{the pameters, internally passed as a list to the
quality method as \code{pars = list(...)}}
}
\value{
a number
}
\description{
A collection of functions to compute quality measures on
\code{\link{dimRedResult}} objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{dimRedResult}: Calculate a quality index from a dimRedResult object.
}}
\section{Implemented methods}{


Method must be one of \code{"\link{Q_local}", "\link{Q_global}",
"\link{mean_R_NX}", "\link{total_correlation}",
"\link{cophenetic_correlation}", "\link{distance_correlation}",
"\link{reconstruction_rmse}"}
}

\section{Rank based criteria}{


\code{Q_local}, \code{Q_global}, and \code{mean_R_nx} are
quality criteria based on the Co-ranking matrix.  \code{Q_local}
and \code{Q_global} determine the local/global quality of the
embedding, while \code{mean_R_nx} determines the quality of the
overall embedding. They are parameter free and return a single
number. The object must include the original data.  The number
returns is in the range [0, 1], higher values mean a better
local/global embedding.
}

\section{Correlation based criteria}{


\code{total_correlation} calculates the sum of the mean squared
correlations of the original axes with the axes in reduced
dimensions, because some methods do not care about correlations
with axes, there is an option to rotate data in reduced space to
maximize this criterium. The number may be greater than one if more
dimensions are summed up.

\code{cophenetic_correlation} calculate the correlation between the
lower triangles of distance matrices, the correlation and distance
methods may be specified. The result is in range [-1, 1].

\code{distance_correlation} measures the independes of samples by
calculating the correlation of distances. For details see
\code{\link[energy]{dcor}}.
}

\section{Reconstruction error}{


\code{reconstruction_rmse} calculates the root mean squared error
of the reconstrucion. \code{object} requires an inverse function.
}
\examples{
\dontrun{
embed_methods <- dimRedMethodList()
quality_methods <- dimRedQualityList()
scurve <- loadDataSet("3D S Curve", n = 500)

quality_results <- matrix(NA, length(embed_methods), length(quality_methods),
                              dimnames = list(embed_methods, quality_methods))
embedded_data <- list()

for (e in embed_methods) {
  message("embedding: ", e)
  embedded_data[[e]] <- embed(scurve, e, .mute = c("message", "output"))
  for (q in quality_methods) {
    message("  quality: ", q)
    quality_results[e, q] <- tryCatch(
      quality(embedded_data[[e]], q),
      error = function (e) NA
    )
  }
}

print(quality_results)
}
}
\author{
Guido Kraemer
}
\references{
Lueks, W., Mokbel, B., Biehl, M., Hammer, B., 2011. How
    to Evaluate Dimensionality Reduction? - Improving the
    Co-ranking Matrix. arXiv:1110.3917 [cs].

Szekely, G.J., Rizzo, M.L., Bakirov, N.K., 2007. Measuring and
    testing dependence by correlation of distances. Ann. Statist. 35,
    2769-2794. doi:10.1214/009053607000000505

Lee, J.A., Peluffo-Ordonez, D.H., Verleysen, M., 2015. Multi-scale
    similarities in stochastic neighbour embedding: Reducing
    dimensionality while preserving both local and global
    structure. Neurocomputing, 169,
    246-261. doi:10.1016/j.neucom.2014.12.095
}
\seealso{
Other Quality scores for dimensionality reduction: \code{\link{AUC_lnK_R_NX,dimRedResult-method}},
  \code{\link{LCMC,dimRedResult-method}},
  \code{\link{Q_NX,dimRedResult-method}},
  \code{\link{Q_global,dimRedResult-method}},
  \code{\link{Q_local,dimRedResult-method}},
  \code{\link{R_NX,dimRedResult-method}},
  \code{\link{cophenetic_correlation,dimRedResult-method}},
  \code{\link{distance_correlation,dimRedResult-method}},
  \code{\link{mean_R_NX,dimRedResult-method}},
  \code{\link{reconstruction_rmse,dimRedResult-method}},
  \code{\link{total_correlation,dimRedResult-method}}
}

