% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_day_of_quarter.R
\name{first_day_yq}
\alias{first_day_yq}
\alias{last_day_yq}
\title{Get First or Last Day of Quarter From Year and Quarter}
\usage{
first_day_yq(x, q = NULL)

last_day_yq(x, q = NULL)
}
\arguments{
\item{x}{Anything that can be coerced to a date with \code{\link[base:as.Date]{base::as.Date()}}}

\item{q}{Two integer (vectors). \code{q} is optional and the interpretation of
\code{x} will depend on whether \code{q} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_yq]{as_date_yq()}}
(e.g. \code{x = 20161} means first quarter of 2016)
\item if \code{x} and \code{q} are supplied, \code{x} is interpreted as year and \code{q} as
quarter.
}}
}
\value{
a \link{Date}
}
\description{
Get First or Last Day of Quarter From Year and Quarter
}
\examples{

first_day_yq(2016, 1)
first_day_yq(20161)

}
\seealso{
\code{\link[=first_day_of_quarter]{first_day_of_quarter()}}

Other yq convenience functions: \code{\link{format_yq}}
}
\concept{yq convenience functions}
