% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_yq.R
\name{format.date_yq}
\alias{format.date_yq}
\alias{format_date_yq_iso}
\alias{format_date_yq_short}
\alias{format_date_yq_shorter}
\title{Format a date_yq Object}
\usage{
\method{format}{date_yq}(x, format = "iso", ...)

format_date_yq_iso(x)

format_date_yq_short(x)

format_date_yq_shorter(x)
}
\arguments{
\item{x}{a \link{date_yq} object}

\item{format}{A scalar character, valid values are: \code{"iso"}, \code{"short"}, and
\code{"shorter"}}

\item{...}{ignored}
}
\value{
A character vector
}
\description{
Format a date_yq Object
}
\examples{

x <- date_yq(2015, 3)

format(x, format = "iso")
# [1] "2015-Q3"

format(x, format = "short")
# [1] "2015.3"

format(x, format = "shorter")
# [1] "15.3"

}
