% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{ask_or_default}
\alias{ask_or_default}
\title{Read a Line from the Terminal, but with Default Values}
\usage{
ask_or_default(..., default = "", end = "", level = "INFO")
}
\arguments{
\item{..., end, level}{passed to \code{\link[dipsaus]{cat2}}}

\item{default}{default value to return in case of blank input}
}
\value{
A character from the user's input, or the default value. See details.
}
\description{
Ask a question and read from the terminal in interactive scenario
}
\details{
The prompt string will ask a question, providing defaults. Users
need to enter the answer. If the answer is blank (no space), then returns the
default, otherwise returns the user input.

This can only be used in an \code{\link{interactive}} session.
}
\examples{
if(interactive()){
ask_or_default('What is the best programming language?',
               default = 'PHP')
}
}
\seealso{
\code{\link[dipsaus]{cat2}}, \code{\link[base]{readline}},
\code{\link[dipsaus]{ask_yesno}}
}
