% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.R
\name{in_revisions}
\alias{in_revisions}
\title{Comparing two disaggregations together}
\usage{
in_revisions(object, object_old, type = "changes")
}
\arguments{
\item{object}{an object of class \code{"twoStepsBenchmark"} or \code{"threeRuleSmooth"}.}

\item{object_old}{an object of class \code{"twoStepsBenchmark"} or \code{"threeRuleSmooth"}.}

\item{type}{\code{"levels"},\code{"levels-rebased"}, \code{"changes"} or \code{"contributions"}.
This defines the type of output.}
}
\value{
a named matrix time series of two columns, one for the response and the other
for the predicted value.
A \code{tscomparison} class is added to the object.
}
\description{
The function \code{in_revisions}takes two inputs, \link{twoStepsBenchmark} or a
\link{threeRuleSmooth}, and produces a comparison between those.
}
\details{
The functions \code{plot} and \code{autoplot} can be used on this object to produce
graphics.
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction,include.rho = TRUE)
benchmark2 <- twoStepsBenchmark(turnover,construction,include.differenciation = TRUE)
plot(in_revisions(benchmark,benchmark2))
}
\seealso{
\link{in_sample} \link{in_disaggr} \link{in_scatter}
\link{plot.tscomparison}
}
