% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{corOrt}
\alias{corOrt}
\title{Calculate ortholog gene correlation coefficients}
\usage{
corOrt(x, g = NULL, pval = 0.05, lfc = 0)
}
\arguments{
\item{x}{an object of class matchedOrtholog}

\item{g}{either a vector of gene names of genes of interest, 
or an object of class "tmod" with definitions of modules. If
NULL, all genes will be used}

\item{pval}{p value threshold}

\item{lfc}{log_2 fold change threshold}
}
\value{
corOrt returns a data frame with the following columns:
\describe{
  \item{r}{Pearson correlation coefficient r}
  \item{Seok}{correlation measure described by Seok et al. -- squared
  Pearson r correlation coefficient for genes significantly up- or
  downregulated in one of the two orthologous sets}
  \item{Seok.N}{number of gene pairs that were used to calculate the Seok
  coefficient}
  \item{rho}{Spearman correlation coefficient rho}
  \item{Takao}{correlation measure described by Takao et al. -- Spearman
  correlation coefficient for genes significantly up- or downregulated in
  both of the two gene orthologous sets}
  \item{Takao.N}{number of gene pairs that were used to calculate the Takao
  coefficient; smaller or equal to Seok.N}
  \item{N}{total number of gene pairs in the given gene set}
}
}
\description{
Calculate correlation between sets of matched orthologous genes using
either method from Takao et al. (2015) or Seok et al. (2013)
}
\details{
This function calculates Pearson Correlation, squared Pearson correlation and Spearman correlation 
for mouse and human logFC values for genes with significant p-values for differential regulation. 
As in PNAS 2013 110 (9) 3507-3512, for the calculation of squared Pearson correlation coefficient 
all the genes that are significantly regulated in at least one specie are taken into account, 
while for the calculation of Spearman's correlation coefficient only the genes significantly regulated in both species
as in PNAS 2015 112 (4) 1167-1172.

The parameters can be calculated either for all genes in the
\code{orthologs} object, for an explicit list of genes as a character
vector parameter \code{g}, or for a set of \code{tmod} modules, if the
parameter \code{g} is an object of class \code{tmod}.
}
\section{Bibliography}{

Seok, Junhee, et al. "Genomic responses in mouse models poorly mimic human
inflammatory diseases." Proceedings of the National Academy of Sciences
110.9 (2013): 3507-3512.

Takao, Keizo, and Tsuyoshi Miyakawa. "Genomic responses in mouse models
greatly mimic human inflammatory diseases." Proceedings of the National
Academy of Sciences 112.4 (2015): 1167-1172.
}

\examples{
library(tmod)
data(tmod)
data(orthologs)
a <- corOrt(orthologs)
disco <- disco.score(orthologs)
ord <- order(disco, decreasing = TRUE)
concordant <- tmodCERNOtest(toupper(orthologs$genes)[ord])
corOrt(orthologs, g=tmod[concordant$ID])
}
\seealso{
modCor
}
