% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.r, R/collect.summarized_disk.frame.r
\name{collect.disk.frame}
\alias{collect.disk.frame}
\alias{collect_list}
\alias{collect.summarized_disk.frame}
\title{Bring the disk.frame into R}
\usage{
\method{collect}{disk.frame}(x, ..., parallel = !is.null(attr(x, "lazyfn")))

collect_list(x, simplify = FALSE, parallel = !is.null(attr(x, "lazyfn")))

\method{collect}{summarized_disk.frame}(x, ..., parallel = !is.null(attr(x, "lazyfn")))
}
\arguments{
\item{x}{a disk.frame}

\item{...}{not used}

\item{parallel}{if TRUE the collection is performed in parallel. By default
if there are delayed/lazy steps then it will be parallel, otherwise it will
not be in parallel. This is because parallel requires transferring data
from background R session to the current R session and if there is no
computation then it's better to avoid transferring data between session,
hence parallel = FALSE is a better choice}

\item{simplify}{Should the result be simplified to array}
}
\value{
collect return a data.frame/data.table

collect_list returns a list

collect return a data.frame/data.table
}
\description{
Bring the disk.frame into RAM by loading the data and running all lazy
operations as data.table/data.frame or as a list

Bring the disk.frame into RAM by loading the data and running all lazy
operations as data.table/data.frame or as a list
}
\examples{
cars.df = as.disk.frame(cars)
# use collect to bring the data into RAM as a data.table/data.frame
collect(cars.df)

# clean up
delete(cars.df)
cars.df = as.disk.frame(cars)

# returns the result as a list
collect_list(cmap(cars.df, ~1))

# clean up
delete(cars.df)
cars.df = as.disk.frame(cars)
# use collect to bring the data into RAM as a data.table/data.frame
collect(cars.df)

# clean up
delete(cars.df)
}
