% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.wrapper.R
\name{dispRity.per.group}
\alias{dispRity.per.group}
\title{Disparity in different groups.}
\usage{
dispRity.per.group(data, group, metric = c(median, centroids), ...)
}
\arguments{
\item{data}{An ordinated \code{matrix}.}

\item{group}{A \code{list} of row numbers for each group.}

\item{metric}{A vector containing one to three functions (default = \code{c(median, centroids)}) (see \code{\link{dispRity}} for details).}

\item{...}{Optional arguments to be passed to \code{\link{custom.subsets}}, \code{\link{boot.matrix}} and \code{\link{dispRity}}.}
}
\value{
A \code{dispRity} object that can be passed to \code{summary} or \code{plot}.
}
\description{
Performs a disparity analysis between groups.
}
\details{
Note that this is a wrapper function that allows users to run a basic disparity among groups analysis without too much effort. 
As such it has a lot of defaults described in the functions that make up the analysis. 
See \code{\link{custom.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity.metric}}, \code{\link{summary.dispRity}}, \code{\link{plot.dispRity}} for more details of the defaults used in each of these functions.
Note that any of these defaults can be changed within the \code{disparity.through.time} function.
For more details see the \code{dispRity} manual.
}
\examples{
## Load the Beck & Lee 2014 data
data(BeckLee_mat50)

## Run a simple disparity per group analysis comparing stem and crown mammals
result <- dispRity.per.group(BeckLee_mat50, list(crown = c(16, 19:41, 45:50),
                             stem = c(1:15, 17:18, 42:44)))
summary(result) ; plot(result)

}
\seealso{
\code{\link{custom.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity.metric}}, \code{\link{summary.dispRity}}, \code{\link{plot.dispRity}}.
}
\author{
Thomas Guillerme
}
