% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.covar.projections.R
\name{dispRity.covar.projections}
\alias{dispRity.covar.projections}
\title{Covar projection analyses wrapper}
\usage{
dispRity.covar.projections(
  data,
  type,
  base,
  sample,
  n,
  major.axis = 1,
  level = 0.95,
  output = c("position", "distance", "degree"),
  inc.base = FALSE,
  ...,
  verbose = FALSE
)
}
\arguments{
\item{data}{a \code{dispRity} object containing a \code{$covar} component(e.g. from \code{\link{MCMCglmm.subsets}})}

\item{type}{either \code{"groups"} for the projections between groups or \code{"elements"} for the projections of elements onto groups.}

\item{base}{optional, a specific group to project the elements or the groups onto or a list of pairs of groups to compare (see \code{between.groups} argument in \code{\link{dispRity}}). If left empty, the groups are projected onto each other in a pairwise manner and the elements are projected onto their respective groups.}

\item{sample}{optional, one or more specific posterior sample IDs (is ignored if n is used) or a function to summarise all axes.}

\item{n}{optional, a random number of covariance matrices to sample (if left empty, all are used).}

\item{major.axis}{which major axis to use (default is \code{1}; see \code{\link{axis.covar}} for more details).}

\item{level}{the confidence interval to estimate the major axis (default is \code{0.95}; see \code{\link{axis.covar}} for more details)).}

\item{output}{which values to output from the projection. By default, the three values \code{c("position", "distance", "degree")} are used to respectively output the projection, rejection and angle values (see \code{\link{projections}} for more details).}

\item{inc.base}{logical, when using \code{type = "elements"} with a supplied \code{base} argument, whether to also calculate the projections for the base group (\code{TRUE}) or not (\code{FALSE}; default).}

\item{...}{any optional arguments to pass to \code{\link{projections}} (such as \code{centre} or \code{abs}).}

\item{verbose}{logical, whether to be verbose (\code{TRUE}) or not (\code{FALSE}, default).}
}
\value{
A \code{list} of class \code{"dispRity"} and \code{"projection"} which contains \code{dispRity} objects corresponding to each projection value from \code{output}.
The elements of the \code{list} can be accessed and analysed individually by selecting them by name (e.g. \code{output$position}) or by ID (e.g. \code{output[[1]]}).
Alternatively, the list can be summarised and plotted using \code{\link{summary.dispRity}} \code{\link{plot.dispRity}}.
}
\description{
Wrapper function for a covar projection analyses on dispRity objects
}
\details{
Effectively, the wrapper runs either of the following function (simplified here):
\itemize{
     \item if \code{type = "groups"}: \code{dispRity(data, metric = as.covar(projections.between), between.groups = TRUE, )} for the projections group in \code{data} onto each other. 
     \item if \code{type = "elements"}: \code{dispRity(data, metric = as.covar(projections), ...)} for the projections of each element in \code{data} onto their main axis.
}

If \code{base} is specified:
\itemize{
     \item \code{type = "groups"} will run pairs elements each subset and \code{base} (instead of the full pairwise analyses).
     \item \code{type = "elements"} will run the projection of each subset onto the major axis from \code{base} rather than its own.
}
}
\examples{
data(charadriiformes)

## Creating a dispRity object with a covar component
my_covar <-MCMCglmm.subsets(
                 data       = charadriiformes$data,
                 posteriors = charadriiformes$posteriors,
                 tree       = charadriiformes$tree,
                 group      = MCMCglmm.levels(
                                 charadriiformes$posteriors)[1:4],
                 rename.groups = c("gulls", "plovers", "sandpipers", "phylo"))

## Running a projection analyses between groups (on 100 random samples)
between_groups <- dispRity.covar.projections(my_covar, type = "groups", base = "phylo", n = 100)
## Summarising the results
summary(between_groups)

## Measuring the projection of the elements on their own average major axis
elements_proj <- dispRity.covar.projections(my_covar, type = "elements", sample = mean,
                                            output = c("position", "distance"))
## Visualising the results
plot(elements_proj)

## Visualising the correlation
plot(elements_proj, speicfic.args = list(correlation.plot = c("position", "distance")))

}
\seealso{
\code{\link{projections}} \code{\link{projections.between}} \code{\link{axis.covar}} \code{\link{dispRity}} \code{\link{MCMCglmm.subsets}}
}
\author{
Thomas Guillerme
}
