% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_names.R
\name{zoo_name_get}
\alias{zoo_name_get}
\title{Get Name of a Zoo Time Series}
\usage{
zoo_name_get(x = NULL)
}
\arguments{
\item{x}{(required, zoo object) Zoo time series to analyze. Default: NULL.}
}
\value{
character string
}
\description{
Just a convenient wrapper of \code{attributes(x)$name}.
}
\examples{
#simulate zoo time series
x <- zoo_simulate()

#get current name
zoo_name_get(x = x)

#change name
x <- zoo_name_set(
  x = x,
  name = "My.New.name"
)

zoo_name_get(x = x)

#clean name
x <- zoo_name_clean(
  x = x,
  lowercase = TRUE
)

zoo_name_get(x = x)
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
